/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.issue;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.io.Serializable;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import org.sonar.api.ce.ComputeEngineSide;
import org.sonar.api.rules.RuleType;
import org.sonar.api.server.ServerSide;
import org.sonar.api.server.rule.RuleTagFormat;
import org.sonar.api.utils.Duration;
import org.sonar.core.issue.DefaultIssue;
import org.sonar.core.issue.DefaultIssueComment;
import org.sonar.core.issue.IssueChangeContext;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.db.user.UserDto;

@ServerSide
@ComputeEngineSide
public class IssueFieldsSetter {
    public static final String UNUSED = "";
    public static final String SEVERITY = "severity";
    public static final String TYPE = "type";
    public static final String ASSIGNEE = "assignee";
    public static final String RESOLUTION = "resolution";
    public static final String STATUS = "status";
    public static final String AUTHOR = "author";
    public static final String FILE = "file";
    public static final String FROM_LONG_BRANCH = "from_long_branch";
    public static final String FROM_SHORT_BRANCH = "from_short_branch";
    public static final String TECHNICAL_DEBT = "technicalDebt";
    public static final String TAGS = "tags";
    private static final Joiner CHANGELOG_TAG_JOINER = Joiner.on((String)" ").skipNulls();

    public boolean setType(DefaultIssue issue, RuleType type, IssueChangeContext context) {
        if (!Objects.equals(type, issue.type())) {
            issue.setFieldChange(context, TYPE, (Serializable)issue.type(), (Serializable)type);
            issue.setType(type);
            issue.setUpdateDate(context.date());
            issue.setChanged(true);
            return true;
        }
        return false;
    }

    public boolean setSeverity(DefaultIssue issue, String severity, IssueChangeContext context) {
        Preconditions.checkState((!issue.manualSeverity() ? 1 : 0) != 0, (Object)"Severity can't be changed");
        if (!Objects.equals(severity, issue.severity())) {
            issue.setFieldChange(context, SEVERITY, (Serializable)((Object)issue.severity()), (Serializable)((Object)severity));
            issue.setSeverity(severity);
            issue.setUpdateDate(context.date());
            issue.setChanged(true);
            return true;
        }
        return false;
    }

    public boolean setPastSeverity(DefaultIssue issue, @Nullable String previousSeverity, IssueChangeContext context) {
        String currentSeverity = issue.severity();
        issue.setSeverity(previousSeverity);
        return this.setSeverity(issue, currentSeverity, context);
    }

    public boolean setManualSeverity(DefaultIssue issue, String severity, IssueChangeContext context) {
        if (!issue.manualSeverity() || !Objects.equals(severity, issue.severity())) {
            issue.setFieldChange(context, SEVERITY, (Serializable)((Object)issue.severity()), (Serializable)((Object)severity));
            issue.setSeverity(severity);
            issue.setManualSeverity(true);
            issue.setUpdateDate(context.date());
            issue.setChanged(true);
            issue.setSendNotifications(true);
            return true;
        }
        return false;
    }

    public boolean assign(DefaultIssue issue, @Nullable UserDto user, IssueChangeContext context) {
        String assigneeUuid;
        String string = assigneeUuid = user != null ? user.getUuid() : null;
        if (!Objects.equals(assigneeUuid, issue.assignee())) {
            String newAssigneeName = user == null ? null : user.getName();
            issue.setFieldChange(context, ASSIGNEE, (Serializable)((Object)UNUSED), (Serializable)((Object)newAssigneeName));
            issue.setAssigneeUuid(user != null ? user.getUuid() : null);
            issue.setUpdateDate(context.date());
            issue.setChanged(true);
            issue.setSendNotifications(true);
            return true;
        }
        return false;
    }

    public boolean setNewAssignee(DefaultIssue issue, @Nullable String newAssigneeUuid, IssueChangeContext context) {
        if (newAssigneeUuid == null) {
            return false;
        }
        Preconditions.checkState((issue.assignee() == null ? 1 : 0) != 0, (Object)"It's not possible to update the assignee with this method, please use assign()");
        issue.setFieldChange(context, ASSIGNEE, (Serializable)((Object)UNUSED), (Serializable)((Object)newAssigneeUuid));
        issue.setAssigneeUuid(newAssigneeUuid);
        issue.setUpdateDate(context.date());
        issue.setChanged(true);
        issue.setSendNotifications(true);
        return true;
    }

    public boolean setLine(DefaultIssue issue, @Nullable Integer line) {
        if (!Objects.equals(line, issue.line())) {
            issue.setLine(line);
            issue.setChanged(true);
            return true;
        }
        return false;
    }

    public boolean setPastLine(DefaultIssue issue, @Nullable Integer previousLine) {
        Integer currentLine = issue.line();
        issue.setLine(previousLine);
        return this.setLine(issue, currentLine);
    }

    public boolean setLocations(DefaultIssue issue, @Nullable Object locations) {
        if (!Objects.equals(locations, issue.getLocations())) {
            issue.setLocations(locations);
            issue.setChanged(true);
            return true;
        }
        return false;
    }

    public boolean setPastLocations(DefaultIssue issue, @Nullable Object previousLocations) {
        Object currentLocations = issue.getLocations();
        issue.setLocations(previousLocations);
        return this.setLocations(issue, currentLocations);
    }

    public boolean setResolution(DefaultIssue issue, @Nullable String resolution, IssueChangeContext context) {
        if (!Objects.equals(resolution, issue.resolution())) {
            issue.setFieldChange(context, RESOLUTION, (Serializable)((Object)issue.resolution()), (Serializable)((Object)resolution));
            issue.setResolution(resolution);
            issue.setUpdateDate(context.date());
            issue.setChanged(true);
            issue.setSendNotifications(true);
            return true;
        }
        return false;
    }

    public boolean setStatus(DefaultIssue issue, String status, IssueChangeContext context) {
        if (!Objects.equals(status, issue.status())) {
            issue.setFieldChange(context, STATUS, (Serializable)((Object)issue.status()), (Serializable)((Object)status));
            issue.setStatus(status);
            issue.setUpdateDate(context.date());
            issue.setChanged(true);
            issue.setSendNotifications(true);
            return true;
        }
        return false;
    }

    public boolean setAuthorLogin(DefaultIssue issue, @Nullable String authorLogin, IssueChangeContext context) {
        if (!Objects.equals(authorLogin, issue.authorLogin())) {
            issue.setFieldChange(context, AUTHOR, (Serializable)((Object)issue.authorLogin()), (Serializable)((Object)authorLogin));
            issue.setAuthorLogin(authorLogin);
            issue.setUpdateDate(context.date());
            issue.setChanged(true);
            return true;
        }
        return false;
    }

    public boolean setNewAuthor(DefaultIssue issue, @Nullable String newAuthorLogin, IssueChangeContext context) {
        if (Strings.isNullOrEmpty((String)newAuthorLogin)) {
            return false;
        }
        Preconditions.checkState((issue.authorLogin() == null ? 1 : 0) != 0, (Object)"It's not possible to update the author with this method, please use setAuthorLogin()");
        issue.setFieldChange(context, AUTHOR, null, (Serializable)((Object)newAuthorLogin));
        issue.setAuthorLogin(newAuthorLogin);
        issue.setUpdateDate(context.date());
        issue.setChanged(true);
        return true;
    }

    public boolean setMessage(DefaultIssue issue, @Nullable String s, IssueChangeContext context) {
        if (!Objects.equals(s, issue.message())) {
            issue.setMessage(s);
            issue.setUpdateDate(context.date());
            issue.setChanged(true);
            return true;
        }
        return false;
    }

    public boolean setPastMessage(DefaultIssue issue, @Nullable String previousMessage, IssueChangeContext context) {
        String currentMessage = issue.message();
        issue.setMessage(previousMessage);
        return this.setMessage(issue, currentMessage, context);
    }

    public void addComment(DefaultIssue issue, String text, IssueChangeContext context) {
        issue.addComment(DefaultIssueComment.create((String)issue.key(), (String)context.userUuid(), (String)text));
        issue.setUpdateDate(context.date());
        issue.setChanged(true);
    }

    public void setCloseDate(DefaultIssue issue, @Nullable Date d, IssueChangeContext context) {
        if (IssueFieldsSetter.relevantDateDifference(d, issue.closeDate())) {
            issue.setCloseDate(d);
            issue.setUpdateDate(context.date());
            issue.setChanged(true);
        }
    }

    public void setCreationDate(DefaultIssue issue, Date d, IssueChangeContext context) {
        if (IssueFieldsSetter.relevantDateDifference(d, issue.creationDate())) {
            issue.setCreationDate(d);
            issue.setUpdateDate(context.date());
            issue.setChanged(true);
        }
    }

    public boolean setGap(DefaultIssue issue, @Nullable Double d, IssueChangeContext context) {
        if (!Objects.equals(d, issue.gap())) {
            issue.setGap(d);
            issue.setUpdateDate(context.date());
            issue.setChanged(true);
            return true;
        }
        return false;
    }

    public boolean setPastGap(DefaultIssue issue, @Nullable Double previousGap, IssueChangeContext context) {
        Double currentGap = issue.gap();
        issue.setGap(previousGap);
        return this.setGap(issue, currentGap, context);
    }

    public boolean setEffort(DefaultIssue issue, @Nullable Duration value, IssueChangeContext context) {
        Duration oldValue = issue.effort();
        if (!Objects.equals(value, oldValue)) {
            issue.setEffort(value);
            issue.setFieldChange(context, TECHNICAL_DEBT, (Serializable)(oldValue != null ? Long.valueOf(oldValue.toMinutes()) : null), value != null ? Long.valueOf(value.toMinutes()) : null);
            issue.setUpdateDate(context.date());
            issue.setChanged(true);
            return true;
        }
        return false;
    }

    public boolean setPastEffort(DefaultIssue issue, @Nullable Duration previousEffort, IssueChangeContext context) {
        Duration currentEffort = issue.effort();
        issue.setEffort(previousEffort);
        return this.setEffort(issue, currentEffort, context);
    }

    public boolean setAttribute(DefaultIssue issue, String key, @Nullable String value, IssueChangeContext context) {
        String oldValue = issue.attribute(key);
        if (!Objects.equals(oldValue, value)) {
            issue.setFieldChange(context, key, (Serializable)((Object)oldValue), (Serializable)((Object)value));
            issue.setAttribute(key, value);
            issue.setUpdateDate(context.date());
            issue.setChanged(true);
            return true;
        }
        return false;
    }

    public boolean setTags(DefaultIssue issue, Collection<String> tags, IssueChangeContext context) {
        Set newTags = (Set)tags.stream().filter(Objects::nonNull).filter(tag -> !tag.isEmpty()).map(tag -> RuleTagFormat.validate((String)tag.toLowerCase(Locale.ENGLISH))).collect(MoreCollectors.toSet());
        HashSet oldTags = new HashSet(issue.tags());
        if (!oldTags.equals(newTags)) {
            issue.setFieldChange(context, TAGS, (Serializable)((Object)(oldTags.isEmpty() ? null : CHANGELOG_TAG_JOINER.join(oldTags))), newTags.isEmpty() ? null : CHANGELOG_TAG_JOINER.join((Iterable)newTags));
            issue.setTags((Collection)newTags);
            issue.setUpdateDate(context.date());
            issue.setChanged(true);
            issue.setSendNotifications(true);
            return true;
        }
        return false;
    }

    public boolean setIssueMoved(DefaultIssue issue, String newComponentUuid, IssueChangeContext context) {
        if (!Objects.equals(newComponentUuid, issue.componentUuid())) {
            issue.setFieldChange(context, FILE, (Serializable)((Object)issue.componentUuid()), (Serializable)((Object)newComponentUuid));
            issue.setComponentUuid(newComponentUuid);
            issue.setUpdateDate(context.date());
            issue.setChanged(true);
            return true;
        }
        return false;
    }

    private static boolean relevantDateDifference(@Nullable Date left, @Nullable Date right) {
        return !Objects.equals(IssueFieldsSetter.truncateMillis(left), IssueFieldsSetter.truncateMillis(right));
    }

    private static Date truncateMillis(@Nullable Date d) {
        if (d == null) {
            return null;
        }
        return Date.from(d.toInstant().truncatedTo(ChronoUnit.SECONDS));
    }
}

