/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.health;

import java.util.function.Supplier;
import org.sonar.api.config.Configuration;
import org.sonar.api.platform.Server;
import org.sonar.process.NetworkUtils;
import org.sonar.process.ProcessProperties;
import org.sonar.process.cluster.health.NodeDetails;
import org.sonar.process.cluster.health.NodeHealth;
import org.sonar.process.cluster.health.NodeHealthProvider;
import org.sonar.server.health.Health;
import org.sonar.server.health.HealthChecker;

public class NodeHealthProviderImpl
implements NodeHealthProvider {
    private final HealthChecker healthChecker;
    private final NodeHealth.Builder nodeHealthBuilder;
    private final NodeDetails nodeDetails;

    public NodeHealthProviderImpl(Configuration configuration, HealthChecker healthChecker, Server server, NetworkUtils networkUtils) {
        this.healthChecker = healthChecker;
        this.nodeHealthBuilder = NodeHealth.newNodeHealthBuilder();
        this.nodeDetails = NodeDetails.newNodeDetailsBuilder().setName(NodeHealthProviderImpl.computeName(configuration)).setType(NodeDetails.Type.APPLICATION).setHost(NodeHealthProviderImpl.computeHost(configuration, networkUtils)).setPort(NodeHealthProviderImpl.computePort(configuration)).setStartedAt(server.getStartedAt().getTime()).build();
    }

    private static String computeName(Configuration configuration) {
        return (String)configuration.get(ProcessProperties.Property.CLUSTER_NODE_NAME.getKey()).orElseThrow(NodeHealthProviderImpl.missingPropertyISE(ProcessProperties.Property.CLUSTER_NODE_NAME.getKey()));
    }

    private static String computeHost(Configuration configuration, NetworkUtils networkUtils) {
        return configuration.get(ProcessProperties.Property.CLUSTER_NODE_HOST.getKey()).filter(s -> !s.isEmpty()).orElseGet(() -> ((NetworkUtils)networkUtils).getHostname());
    }

    private static int computePort(Configuration configuration) {
        return (Integer)configuration.getInt(ProcessProperties.Property.CLUSTER_NODE_HZ_PORT.getKey()).orElseThrow(NodeHealthProviderImpl.missingPropertyISE(ProcessProperties.Property.CLUSTER_NODE_HZ_PORT.getKey()));
    }

    private static Supplier<IllegalStateException> missingPropertyISE(String propertyName) {
        return () -> new IllegalStateException(String.format("Property %s is not defined", propertyName));
    }

    public NodeHealth get() {
        Health nodeHealth = this.healthChecker.checkNode();
        this.nodeHealthBuilder.clearCauses().setStatus(NodeHealth.Status.valueOf((String)nodeHealth.getStatus().name()));
        nodeHealth.getCauses().forEach(arg_0 -> ((NodeHealth.Builder)this.nodeHealthBuilder).addCause(arg_0));
        return this.nodeHealthBuilder.setDetails(this.nodeDetails).build();
    }
}

