/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.health;

import java.util.function.BinaryOperator;
import org.sonar.server.health.Health;

public enum HealthReducer implements BinaryOperator<Health>
{
    INSTANCE;

    private final Health.Builder builder = Health.newHealthCheckBuilder();

    @Override
    public Health apply(Health left, Health right) {
        this.builder.clear();
        this.builder.setStatus(HealthReducer.worseOf(left.getStatus(), right.getStatus()));
        left.getCauses().forEach(this.builder::addCause);
        right.getCauses().forEach(this.builder::addCause);
        return this.builder.build();
    }

    private static Health.Status worseOf(Health.Status left, Health.Status right) {
        if (left == right) {
            return left;
        }
        if (left.ordinal() > right.ordinal()) {
            return left;
        }
        return right;
    }
}

