/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.es.request;

import java.util.Arrays;
import org.elasticsearch.action.ListenableActionFuture;
import org.elasticsearch.action.search.SearchAction;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.common.unit.TimeValue;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Profiler;
import org.sonar.server.es.EsClient;

public class ProxySearchRequestBuilder
extends SearchRequestBuilder {
    public ProxySearchRequestBuilder(Client client) {
        super((ElasticsearchClient)client, SearchAction.INSTANCE);
    }

    public SearchResponse get() {
        Profiler profiler = Profiler.createIfTrace((Logger)EsClient.LOGGER).start();
        try {
            SearchResponse searchResponse = (SearchResponse)super.execute().actionGet();
            return searchResponse;
        }
        catch (Exception e) {
            throw new IllegalStateException(String.format("Fail to execute %s", this.toString()), e);
        }
        finally {
            if (profiler.isTraceEnabled()) {
                profiler.stopTrace(this.toString());
            }
        }
    }

    public SearchResponse get(TimeValue timeout) {
        throw new IllegalStateException("Not yet implemented");
    }

    public SearchResponse get(String timeout) {
        throw new IllegalStateException("Not yet implemented");
    }

    public ListenableActionFuture<SearchResponse> execute() {
        throw new UnsupportedOperationException("execute() should not be called as it's used for asynchronous");
    }

    public String toString() {
        StringBuilder message = new StringBuilder();
        message.append(String.format("ES search request '%s'", this.request));
        if (((SearchRequest)this.request).indices().length > 0) {
            message.append(String.format(" on indices '%s'", Arrays.toString(((SearchRequest)this.request).indices())));
        }
        if (((SearchRequest)this.request).types().length > 0) {
            message.append(String.format(" on types '%s'", Arrays.toString(((SearchRequest)this.request).types())));
        }
        return message.toString();
    }
}

