/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.es.request;

import org.apache.commons.lang.StringUtils;
import org.elasticsearch.action.ListenableActionFuture;
import org.elasticsearch.action.admin.indices.stats.IndicesStatsAction;
import org.elasticsearch.action.admin.indices.stats.IndicesStatsRequest;
import org.elasticsearch.action.admin.indices.stats.IndicesStatsRequestBuilder;
import org.elasticsearch.action.admin.indices.stats.IndicesStatsResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.common.unit.TimeValue;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Profiler;
import org.sonar.server.es.EsClient;

public class ProxyIndicesStatsRequestBuilder
extends IndicesStatsRequestBuilder {
    public ProxyIndicesStatsRequestBuilder(Client client) {
        super((ElasticsearchClient)client.admin().indices(), IndicesStatsAction.INSTANCE);
    }

    public IndicesStatsResponse get() {
        Profiler profiler = Profiler.createIfTrace((Logger)EsClient.LOGGER).start();
        try {
            IndicesStatsResponse indicesStatsResponse = (IndicesStatsResponse)super.execute().actionGet();
            return indicesStatsResponse;
        }
        catch (Exception e) {
            throw new IllegalStateException(String.format("Fail to execute %s", this.toString()), e);
        }
        finally {
            if (profiler.isTraceEnabled()) {
                profiler.stopTrace(this.toString());
            }
        }
    }

    public IndicesStatsResponse get(TimeValue timeout) {
        throw new IllegalStateException("Not yet implemented");
    }

    public IndicesStatsResponse get(String timeout) {
        throw new IllegalStateException("Not yet implemented");
    }

    public ListenableActionFuture<IndicesStatsResponse> execute() {
        throw new UnsupportedOperationException("execute() should not be called as it's used for asynchronous");
    }

    public String toString() {
        StringBuilder message = new StringBuilder();
        message.append("ES indices stats request");
        if (((IndicesStatsRequest)this.request).indices().length > 0) {
            message.append(String.format(" on indices '%s'", StringUtils.join((Object[])((IndicesStatsRequest)this.request).indices(), (String)",")));
        }
        return message.toString();
    }
}

