/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.es.request;

import org.apache.commons.lang.StringUtils;
import org.elasticsearch.action.ListenableActionFuture;
import org.elasticsearch.action.admin.indices.exists.indices.IndicesExistsAction;
import org.elasticsearch.action.admin.indices.exists.indices.IndicesExistsRequest;
import org.elasticsearch.action.admin.indices.exists.indices.IndicesExistsRequestBuilder;
import org.elasticsearch.action.admin.indices.exists.indices.IndicesExistsResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.common.unit.TimeValue;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Profiler;
import org.sonar.server.es.EsClient;

public class ProxyIndicesExistsRequestBuilder
extends IndicesExistsRequestBuilder {
    public ProxyIndicesExistsRequestBuilder(Client client, String ... indices) {
        super((ElasticsearchClient)client.admin().indices(), IndicesExistsAction.INSTANCE, indices);
    }

    public IndicesExistsResponse get() {
        Profiler profiler = Profiler.createIfTrace((Logger)EsClient.LOGGER).start();
        try {
            IndicesExistsResponse indicesExistsResponse = (IndicesExistsResponse)super.execute().actionGet();
            return indicesExistsResponse;
        }
        catch (Exception e) {
            throw new IllegalStateException(String.format("Fail to execute %s", this.toString()), e);
        }
        finally {
            if (profiler.isTraceEnabled()) {
                profiler.stopTrace(this.toString());
            }
        }
    }

    public IndicesExistsResponse get(TimeValue timeout) {
        throw new IllegalStateException("Not yet implemented");
    }

    public IndicesExistsResponse get(String timeout) {
        throw new IllegalStateException("Not yet implemented");
    }

    public ListenableActionFuture<IndicesExistsResponse> execute() {
        throw new UnsupportedOperationException("execute() should not be called as it's used for asynchronous");
    }

    public String toString() {
        StringBuilder message = new StringBuilder();
        message.append("ES indices exists request");
        if (((IndicesExistsRequest)this.request).indices().length > 0) {
            message.append(String.format(" on indices '%s'", StringUtils.join((Object[])((IndicesExistsRequest)this.request).indices(), (String)",")));
        }
        return message.toString();
    }
}

