/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.es;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.Map;
import org.sonar.api.server.ServerSide;
import org.sonar.server.es.NewIndex;

@ServerSide
public interface IndexDefinition {
    public void define(IndexDefinitionContext var1);

    public static class IndexDefinitionContext {
        private final Map<String, NewIndex> byKey = Maps.newHashMap();

        public NewIndex create(String key, NewIndex.SettingsConfiguration settingsConfiguration) {
            Preconditions.checkArgument((!this.byKey.containsKey(key) ? 1 : 0) != 0, (Object)String.format("Index already exists: %s", key));
            NewIndex index = new NewIndex(key, settingsConfiguration);
            this.byKey.put(key, index);
            return index;
        }

        public Map<String, NewIndex> getIndices() {
            return this.byKey;
        }
    }
}

