/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.computation.task.step;

import com.google.common.base.Optional;
import org.sonar.api.ce.ComputeEngineSide;
import org.sonar.server.computation.task.projectanalysis.analysis.AnalysisMetadataHolder;
import org.sonar.server.computation.task.projectanalysis.component.TreeRootHolder;
import org.sonar.server.computation.task.projectanalysis.measure.Measure;
import org.sonar.server.computation.task.projectanalysis.measure.MeasureRepository;
import org.sonar.server.computation.task.projectanalysis.metric.Metric;
import org.sonar.server.computation.task.projectanalysis.metric.MetricRepository;
import org.sonar.server.computation.task.step.ComputationStep;
import org.sonar.server.computation.task.step.PostMeasuresComputationCheck;

@ComputeEngineSide
public class PostMeasuresComputationChecksStep
implements ComputationStep {
    private final TreeRootHolder treeRootHolder;
    private final MetricRepository metricRepository;
    private final MeasureRepository measureRepository;
    private final AnalysisMetadataHolder analysisMetadataHolder;
    private final PostMeasuresComputationCheck[] extensions;

    public PostMeasuresComputationChecksStep(TreeRootHolder treeRootHolder, MetricRepository metricRepository, MeasureRepository measureRepository, AnalysisMetadataHolder analysisMetadataHolder, PostMeasuresComputationCheck[] extensions) {
        this.treeRootHolder = treeRootHolder;
        this.metricRepository = metricRepository;
        this.measureRepository = measureRepository;
        this.analysisMetadataHolder = analysisMetadataHolder;
        this.extensions = extensions;
    }

    public PostMeasuresComputationChecksStep(TreeRootHolder treeRootHolder, MetricRepository metricRepository, MeasureRepository measureRepository, AnalysisMetadataHolder analysisMetadataHolder) {
        this(treeRootHolder, metricRepository, measureRepository, analysisMetadataHolder, new PostMeasuresComputationCheck[0]);
    }

    @Override
    public void execute() {
        ContextImpl context = new ContextImpl();
        for (PostMeasuresComputationCheck extension : this.extensions) {
            extension.onCheck(context);
        }
    }

    @Override
    public String getDescription() {
        return "Checks executed after computation of measures";
    }

    private class ContextImpl
    implements PostMeasuresComputationCheck.Context {
        private ContextImpl() {
        }

        @Override
        public String getProjectUuid() {
            return PostMeasuresComputationChecksStep.this.analysisMetadataHolder.getProject().getUuid();
        }

        @Override
        public int getNcloc() {
            Metric nclocMetric = PostMeasuresComputationChecksStep.this.metricRepository.getByKey("ncloc");
            Optional<Measure> nclocMeasure = PostMeasuresComputationChecksStep.this.measureRepository.getRawMeasure(PostMeasuresComputationChecksStep.this.treeRootHolder.getRoot(), nclocMetric);
            return nclocMeasure.isPresent() ? ((Measure)nclocMeasure.get()).getIntValue() : 0;
        }
    }
}

