/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.computation.task.projectanalysis.step;

import com.google.common.base.Function;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Ordering;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.server.computation.task.projectanalysis.component.Component;
import org.sonar.server.computation.task.projectanalysis.component.ComponentVisitor;
import org.sonar.server.computation.task.projectanalysis.component.CrawlerDepthLimit;
import org.sonar.server.computation.task.projectanalysis.component.DepthTraversalTypeAwareCrawler;
import org.sonar.server.computation.task.projectanalysis.component.TreeRootHolder;
import org.sonar.server.computation.task.projectanalysis.component.TypeAwareVisitorAdapter;
import org.sonar.server.computation.task.projectanalysis.measure.Measure;
import org.sonar.server.computation.task.projectanalysis.measure.MeasureRepository;
import org.sonar.server.computation.task.projectanalysis.measure.qualitygatedetails.EvaluatedCondition;
import org.sonar.server.computation.task.projectanalysis.measure.qualitygatedetails.QualityGateDetailsData;
import org.sonar.server.computation.task.projectanalysis.metric.Metric;
import org.sonar.server.computation.task.projectanalysis.metric.MetricRepository;
import org.sonar.server.computation.task.projectanalysis.qualitygate.Condition;
import org.sonar.server.computation.task.projectanalysis.qualitygate.ConditionEvaluator;
import org.sonar.server.computation.task.projectanalysis.qualitygate.ConditionStatus;
import org.sonar.server.computation.task.projectanalysis.qualitygate.EvaluationResult;
import org.sonar.server.computation.task.projectanalysis.qualitygate.EvaluationResultTextConverter;
import org.sonar.server.computation.task.projectanalysis.qualitygate.MutableQualityGateStatusHolder;
import org.sonar.server.computation.task.projectanalysis.qualitygate.QualityGate;
import org.sonar.server.computation.task.projectanalysis.qualitygate.QualityGateHolder;
import org.sonar.server.computation.task.projectanalysis.qualitygate.QualityGateStatus;
import org.sonar.server.computation.task.projectanalysis.step.SmallChangesetQualityGateSpecialCase;
import org.sonar.server.computation.task.step.ComputationStep;

public class QualityGateMeasuresStep
implements ComputationStep {
    private static final Ordering<Condition> PERIOD_ORDERING = Ordering.natural().reverse().onResultOf(Condition::hasPeriod);
    private final TreeRootHolder treeRootHolder;
    private final QualityGateHolder qualityGateHolder;
    private final MutableQualityGateStatusHolder qualityGateStatusHolder;
    private final MeasureRepository measureRepository;
    private final MetricRepository metricRepository;
    private final EvaluationResultTextConverter evaluationResultTextConverter;
    private final SmallChangesetQualityGateSpecialCase smallChangesetQualityGateSpecialCase;

    public QualityGateMeasuresStep(TreeRootHolder treeRootHolder, QualityGateHolder qualityGateHolder, MutableQualityGateStatusHolder qualityGateStatusHolder, MeasureRepository measureRepository, MetricRepository metricRepository, EvaluationResultTextConverter evaluationResultTextConverter, SmallChangesetQualityGateSpecialCase smallChangesetQualityGateSpecialCase) {
        this.treeRootHolder = treeRootHolder;
        this.qualityGateHolder = qualityGateHolder;
        this.qualityGateStatusHolder = qualityGateStatusHolder;
        this.evaluationResultTextConverter = evaluationResultTextConverter;
        this.measureRepository = measureRepository;
        this.metricRepository = metricRepository;
        this.smallChangesetQualityGateSpecialCase = smallChangesetQualityGateSpecialCase;
    }

    @Override
    public void execute() {
        new DepthTraversalTypeAwareCrawler(new TypeAwareVisitorAdapter(CrawlerDepthLimit.PROJECT, ComponentVisitor.Order.PRE_ORDER){

            @Override
            public void visitProject(Component project) {
                QualityGateMeasuresStep.this.executeForProject(project);
            }
        }).visit(this.treeRootHolder.getRoot());
    }

    private void executeForProject(Component project) {
        Optional<QualityGate> qualityGate = this.qualityGateHolder.getQualityGate();
        if (qualityGate.isPresent()) {
            QualityGateDetailsDataBuilder builder = new QualityGateDetailsDataBuilder();
            this.updateMeasures(project, qualityGate.get().getConditions(), builder);
            this.addProjectMeasure(project, builder);
            this.updateQualityGateStatusHolder(qualityGate.get(), builder);
        }
    }

    private void updateQualityGateStatusHolder(QualityGate qualityGate, QualityGateDetailsDataBuilder builder) {
        this.qualityGateStatusHolder.setStatus(QualityGateMeasuresStep.convert(builder.getGlobalLevel()), QualityGateMeasuresStep.createStatusPerCondition(qualityGate.getConditions(), builder.getEvaluatedConditions()));
    }

    private static ConditionStatus.EvaluationStatus toEvaluationStatus(Measure.Level globalLevel) {
        switch (globalLevel) {
            case OK: {
                return ConditionStatus.EvaluationStatus.OK;
            }
            case WARN: {
                return ConditionStatus.EvaluationStatus.WARN;
            }
            case ERROR: {
                return ConditionStatus.EvaluationStatus.ERROR;
            }
        }
        throw new IllegalArgumentException(String.format("Unsupported value '%s' of Measure.Level can not be converted to EvaluationStatus", new Object[]{globalLevel}));
    }

    private static QualityGateStatus convert(Measure.Level globalLevel) {
        switch (globalLevel) {
            case OK: {
                return QualityGateStatus.OK;
            }
            case WARN: {
                return QualityGateStatus.WARN;
            }
            case ERROR: {
                return QualityGateStatus.ERROR;
            }
        }
        throw new IllegalArgumentException(String.format("Unsupported value '%s' of Measure.Level can not be converted to QualityGateStatus", new Object[]{globalLevel}));
    }

    private static Map<Condition, ConditionStatus> createStatusPerCondition(Iterable<Condition> conditions, Iterable<EvaluatedCondition> evaluatedConditions) {
        ImmutableMap evaluatedConditionPerCondition = FluentIterable.from(evaluatedConditions).uniqueIndex((Function)EvaluatedConditionToCondition.INSTANCE);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Condition condition : conditions) {
            EvaluatedCondition evaluatedCondition = (EvaluatedCondition)evaluatedConditionPerCondition.get(condition);
            if (evaluatedCondition == null) {
                builder.put((Object)condition, (Object)ConditionStatus.NO_VALUE_STATUS);
                continue;
            }
            builder.put((Object)condition, (Object)ConditionStatus.create(QualityGateMeasuresStep.toEvaluationStatus(evaluatedCondition.getLevel()), evaluatedCondition.getActualValue()));
        }
        return builder.build();
    }

    private void updateMeasures(Component project, Set<Condition> conditions, QualityGateDetailsDataBuilder builder) {
        Multimap conditionsPerMetric = (Multimap)conditions.stream().collect(MoreCollectors.index(Condition::getMetric, java.util.function.Function.identity()));
        boolean ignoredConditions = false;
        for (Map.Entry entry : conditionsPerMetric.asMap().entrySet()) {
            MetricEvaluationResult finalMetricEvaluationResult;
            Metric metric = (Metric)entry.getKey();
            com.google.common.base.Optional<Measure> measure = this.measureRepository.getRawMeasure(project, metric);
            if (!measure.isPresent()) continue;
            MetricEvaluationResult metricEvaluationResult = QualityGateMeasuresStep.evaluateQualityGate((Measure)measure.get(), (Collection)entry.getValue());
            if (this.smallChangesetQualityGateSpecialCase.appliesTo(project, metricEvaluationResult)) {
                finalMetricEvaluationResult = this.smallChangesetQualityGateSpecialCase.apply(metricEvaluationResult);
                ignoredConditions = true;
            } else {
                finalMetricEvaluationResult = metricEvaluationResult;
            }
            String text = this.evaluationResultTextConverter.asText(finalMetricEvaluationResult.condition, finalMetricEvaluationResult.evaluationResult);
            builder.addLabel(text);
            Measure updatedMeasure = Measure.updatedMeasureBuilder((Measure)measure.get()).setQualityGateStatus(new org.sonar.server.computation.task.projectanalysis.measure.QualityGateStatus(finalMetricEvaluationResult.evaluationResult.getLevel(), text)).create();
            this.measureRepository.update(project, metric, updatedMeasure);
            builder.addEvaluatedCondition(finalMetricEvaluationResult);
        }
        builder.setIgnoredConditions(ignoredConditions);
    }

    private static MetricEvaluationResult evaluateQualityGate(Measure measure, Collection<Condition> conditions) {
        ConditionEvaluator conditionEvaluator = new ConditionEvaluator();
        MetricEvaluationResult metricEvaluationResult = null;
        for (Condition newCondition : PERIOD_ORDERING.immutableSortedCopy(conditions)) {
            EvaluationResult newEvaluationResult = conditionEvaluator.evaluate(newCondition, measure);
            if (metricEvaluationResult != null && newEvaluationResult.getLevel().ordinal() <= metricEvaluationResult.evaluationResult.getLevel().ordinal()) continue;
            metricEvaluationResult = new MetricEvaluationResult(newEvaluationResult, newCondition);
        }
        return metricEvaluationResult;
    }

    private void addProjectMeasure(Component project, QualityGateDetailsDataBuilder builder) {
        Measure globalMeasure = Measure.newMeasureBuilder().setQualityGateStatus(new org.sonar.server.computation.task.projectanalysis.measure.QualityGateStatus(builder.getGlobalLevel(), StringUtils.join(builder.getLabels(), (String)", "))).create(builder.getGlobalLevel());
        Metric metric = this.metricRepository.getByKey("alert_status");
        this.measureRepository.add(project, metric, globalMeasure);
        String detailMeasureValue = new QualityGateDetailsData(builder.getGlobalLevel(), builder.getEvaluatedConditions(), builder.isIgnoredConditions()).toJson();
        Measure detailsMeasure = Measure.newMeasureBuilder().create(detailMeasureValue);
        Metric qgDetailsMetric = this.metricRepository.getByKey("quality_gate_details");
        this.measureRepository.add(project, qgDetailsMetric, detailsMeasure);
    }

    @Override
    public String getDescription() {
        return "Compute Quality Gate measures";
    }

    static class MetricEvaluationResult {
        final EvaluationResult evaluationResult;
        final Condition condition;

        MetricEvaluationResult(EvaluationResult evaluationResult, Condition condition) {
            this.evaluationResult = evaluationResult;
            this.condition = condition;
        }
    }

    private static enum EvaluatedConditionToCondition implements Function<EvaluatedCondition, Condition>
    {
        INSTANCE;


        @Nonnull
        public Condition apply(@Nonnull EvaluatedCondition input) {
            return input.getCondition();
        }
    }

    private static final class QualityGateDetailsDataBuilder {
        private Measure.Level globalLevel = Measure.Level.OK;
        private List<String> labels = new ArrayList<String>();
        private List<EvaluatedCondition> evaluatedConditions = new ArrayList<EvaluatedCondition>();
        private boolean ignoredConditions;

        private QualityGateDetailsDataBuilder() {
        }

        public Measure.Level getGlobalLevel() {
            return this.globalLevel;
        }

        public void addLabel(@Nullable String label) {
            if (StringUtils.isNotBlank((String)label)) {
                this.labels.add(label);
            }
        }

        public List<String> getLabels() {
            return this.labels;
        }

        public void addEvaluatedCondition(MetricEvaluationResult metricEvaluationResult) {
            Measure.Level level = metricEvaluationResult.evaluationResult.getLevel();
            if (Measure.Level.WARN == level && this.globalLevel != Measure.Level.ERROR) {
                this.globalLevel = Measure.Level.WARN;
            } else if (Measure.Level.ERROR == level) {
                this.globalLevel = Measure.Level.ERROR;
            }
            this.evaluatedConditions.add(new EvaluatedCondition(metricEvaluationResult.condition, level, metricEvaluationResult.evaluationResult.getValue()));
        }

        public List<EvaluatedCondition> getEvaluatedConditions() {
            return this.evaluatedConditions;
        }

        public boolean isIgnoredConditions() {
            return this.ignoredConditions;
        }

        public QualityGateDetailsDataBuilder setIgnoredConditions(boolean ignoredConditions) {
            this.ignoredConditions = ignoredConditions;
            return this;
        }
    }
}

