/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.computation.task.projectanalysis.step;

import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.purge.IdUuidPair;
import org.sonar.server.computation.dbcleaner.ProjectCleaner;
import org.sonar.server.computation.task.projectanalysis.component.Component;
import org.sonar.server.computation.task.projectanalysis.component.ComponentVisitor;
import org.sonar.server.computation.task.projectanalysis.component.ConfigurationRepository;
import org.sonar.server.computation.task.projectanalysis.component.CrawlerDepthLimit;
import org.sonar.server.computation.task.projectanalysis.component.DbIdsRepository;
import org.sonar.server.computation.task.projectanalysis.component.DepthTraversalTypeAwareCrawler;
import org.sonar.server.computation.task.projectanalysis.component.DisabledComponentsHolder;
import org.sonar.server.computation.task.projectanalysis.component.TreeRootHolder;
import org.sonar.server.computation.task.projectanalysis.component.TypeAwareVisitorAdapter;
import org.sonar.server.computation.task.step.ComputationStep;

public class PurgeDatastoresStep
implements ComputationStep {
    private final ProjectCleaner projectCleaner;
    private final DbClient dbClient;
    private final DbIdsRepository dbIdsRepository;
    private final TreeRootHolder treeRootHolder;
    private final ConfigurationRepository configRepository;
    private final DisabledComponentsHolder disabledComponentsHolder;

    public PurgeDatastoresStep(DbClient dbClient, ProjectCleaner projectCleaner, DbIdsRepository dbIdsRepository, TreeRootHolder treeRootHolder, ConfigurationRepository configRepository, DisabledComponentsHolder disabledComponentsHolder) {
        this.projectCleaner = projectCleaner;
        this.dbClient = dbClient;
        this.dbIdsRepository = dbIdsRepository;
        this.treeRootHolder = treeRootHolder;
        this.configRepository = configRepository;
        this.disabledComponentsHolder = disabledComponentsHolder;
    }

    @Override
    public void execute() {
        new DepthTraversalTypeAwareCrawler(new TypeAwareVisitorAdapter(CrawlerDepthLimit.reportMaxDepth(Component.Type.PROJECT).withViewsMaxDepth(Component.Type.VIEW), ComponentVisitor.Order.PRE_ORDER){

            @Override
            public void visitProject(Component project) {
                PurgeDatastoresStep.this.execute(project);
            }

            @Override
            public void visitView(Component view) {
                PurgeDatastoresStep.this.execute(view);
            }
        }).visit(this.treeRootHolder.getRoot());
    }

    private void execute(Component root) {
        try (DbSession dbSession = this.dbClient.openSession(true);){
            IdUuidPair idUuidPair = new IdUuidPair(this.dbIdsRepository.getComponentId(root), root.getUuid());
            this.projectCleaner.purge(dbSession, idUuidPair, this.configRepository.getConfiguration(), this.disabledComponentsHolder.getUuids());
            dbSession.commit();
        }
    }

    @Override
    public String getDescription() {
        return "Purge db";
    }
}

