/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.computation.task.projectanalysis.step;

import com.google.common.base.Optional;
import javax.annotation.CheckForNull;
import org.sonar.api.config.Configuration;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.component.ComponentDto;
import org.sonar.server.computation.task.projectanalysis.analysis.AnalysisMetadataHolder;
import org.sonar.server.computation.task.projectanalysis.component.Component;
import org.sonar.server.computation.task.projectanalysis.component.ComponentVisitor;
import org.sonar.server.computation.task.projectanalysis.component.ConfigurationRepository;
import org.sonar.server.computation.task.projectanalysis.component.CrawlerDepthLimit;
import org.sonar.server.computation.task.projectanalysis.component.DepthTraversalTypeAwareCrawler;
import org.sonar.server.computation.task.projectanalysis.component.TreeRootHolder;
import org.sonar.server.computation.task.projectanalysis.component.TypeAwareVisitorAdapter;
import org.sonar.server.computation.task.projectanalysis.period.Period;
import org.sonar.server.computation.task.projectanalysis.period.PeriodHolderImpl;
import org.sonar.server.computation.task.projectanalysis.step.PeriodResolver;
import org.sonar.server.computation.task.step.ComputationStep;

public class LoadPeriodsStep
implements ComputationStep {
    private final DbClient dbClient;
    private final ConfigurationRepository configRepository;
    private final TreeRootHolder treeRootHolder;
    private final AnalysisMetadataHolder analysisMetadataHolder;
    private final PeriodHolderImpl periodsHolder;

    public LoadPeriodsStep(DbClient dbClient, ConfigurationRepository settingsRepository, TreeRootHolder treeRootHolder, AnalysisMetadataHolder analysisMetadataHolder, PeriodHolderImpl periodsHolder) {
        this.dbClient = dbClient;
        this.configRepository = settingsRepository;
        this.treeRootHolder = treeRootHolder;
        this.analysisMetadataHolder = analysisMetadataHolder;
        this.periodsHolder = periodsHolder;
    }

    @Override
    public void execute() {
        new DepthTraversalTypeAwareCrawler(new TypeAwareVisitorAdapter(CrawlerDepthLimit.PROJECT, ComponentVisitor.Order.PRE_ORDER){

            @Override
            public void visitProject(Component project) {
                LoadPeriodsStep.this.execute(project);
            }
        }).visit(this.treeRootHolder.getRoot());
    }

    public void execute(Component projectOrView) {
        try (DbSession dbSession = this.dbClient.openSession(false);){
            this.periodsHolder.setPeriod(this.buildPeriod(projectOrView, dbSession));
        }
    }

    @CheckForNull
    private Period buildPeriod(Component projectOrView, DbSession session) {
        Configuration config;
        Optional projectDto = this.dbClient.componentDao().selectByKey(session, projectOrView.getKey());
        if (!projectDto.isPresent()) {
            return null;
        }
        boolean isReportType = projectOrView.getType().isReportType();
        PeriodResolver periodResolver = new PeriodResolver(this.dbClient, session, ((ComponentDto)projectDto.get()).uuid(), this.analysisMetadataHolder.getAnalysisDate(), isReportType ? projectOrView.getReportAttributes().getVersion() : null);
        Period period = periodResolver.resolve(config = this.configRepository.getConfiguration());
        if (period != null) {
            return period;
        }
        return null;
    }

    @Override
    public String getDescription() {
        return "Load differential periods";
    }
}

