/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.computation.task.projectanalysis.step;

import java.sql.SQLException;
import org.sonar.server.computation.task.projectanalysis.dbmigration.ProjectAnalysisDataChange;
import org.sonar.server.computation.task.projectanalysis.dbmigration.ProjectAnalysisDataChanges;
import org.sonar.server.computation.task.step.ComputationStep;

public class DbMigrationsStep
implements ComputationStep {
    private final ProjectAnalysisDataChanges dataChanges;

    public DbMigrationsStep(ProjectAnalysisDataChanges dataChanges) {
        this.dataChanges = dataChanges;
    }

    @Override
    public String getDescription() {
        return "Execute DB migrations for current project";
    }

    @Override
    public void execute() {
        this.dataChanges.getDataChanges().forEach(DbMigrationsStep::execute);
    }

    private static void execute(ProjectAnalysisDataChange dataChange) {
        try {
            dataChange.execute();
        }
        catch (SQLException e) {
            throw new IllegalStateException("Failed to perform DB migration for project", e);
        }
    }
}

