/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.computation.task.projectanalysis.step;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.StreamSupport;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.measure.PastMeasureDto;
import org.sonar.server.computation.task.projectanalysis.component.Component;
import org.sonar.server.computation.task.projectanalysis.component.ComponentVisitor;
import org.sonar.server.computation.task.projectanalysis.component.CrawlerDepthLimit;
import org.sonar.server.computation.task.projectanalysis.component.DepthTraversalTypeAwareCrawler;
import org.sonar.server.computation.task.projectanalysis.component.TreeRootHolder;
import org.sonar.server.computation.task.projectanalysis.component.TypeAwareVisitorAdapter;
import org.sonar.server.computation.task.projectanalysis.measure.Measure;
import org.sonar.server.computation.task.projectanalysis.measure.MeasureKey;
import org.sonar.server.computation.task.projectanalysis.measure.MeasureRepository;
import org.sonar.server.computation.task.projectanalysis.metric.Metric;
import org.sonar.server.computation.task.projectanalysis.metric.MetricRepository;
import org.sonar.server.computation.task.projectanalysis.period.Period;
import org.sonar.server.computation.task.projectanalysis.period.PeriodHolder;
import org.sonar.server.computation.task.step.ComputationStep;

public class ComputeMeasureVariationsStep
implements ComputationStep {
    private final DbClient dbClient;
    private final TreeRootHolder treeRootHolder;
    private final PeriodHolder periodHolder;
    private final MetricRepository metricRepository;
    private final MeasureRepository measureRepository;

    public ComputeMeasureVariationsStep(DbClient dbClient, TreeRootHolder treeRootHolder, PeriodHolder periodHolder, MetricRepository metricRepository, MeasureRepository measureRepository) {
        this.dbClient = dbClient;
        this.treeRootHolder = treeRootHolder;
        this.periodHolder = periodHolder;
        this.metricRepository = metricRepository;
        this.measureRepository = measureRepository;
    }

    @Override
    public void execute() {
        try (DbSession dbSession = this.dbClient.openSession(false);){
            List metrics = (List)StreamSupport.stream(this.metricRepository.getAll().spliterator(), false).filter(ComputeMeasureVariationsStep.isNumeric()).collect(MoreCollectors.toList());
            new DepthTraversalTypeAwareCrawler(new VariationMeasuresVisitor(dbSession, metrics)).visit(this.treeRootHolder.getRoot());
        }
    }

    private static Predicate<Metric> isNumeric() {
        return metric -> {
            Measure.ValueType valueType = metric.getType().getValueType();
            return Measure.ValueType.INT.equals((Object)valueType) || Measure.ValueType.LONG.equals((Object)valueType) || Measure.ValueType.DOUBLE.equals((Object)valueType) || Measure.ValueType.BOOLEAN.equals((Object)valueType);
        };
    }

    @Override
    public String getDescription() {
        return "Compute measure variations";
    }

    private static final class MeasureWithVariation {
        private final Metric metric;
        private final Measure measure;
        private Double variation;

        MeasureWithVariation(Metric metric, Measure measure) {
            this.metric = metric;
            this.measure = measure;
        }

        public Measure getMeasure() {
            return this.measure;
        }

        public Metric getMetric() {
            return this.metric;
        }

        public void setVariation(@Nullable Double value) {
            this.variation = value;
        }

        @CheckForNull
        public Double getVariation() {
            return this.variation;
        }
    }

    private static final class MeasuresWithVariationRepository {
        private final Map<MeasureKey, MeasureWithVariation> measuresWithVariations = new HashMap<MeasureKey, MeasureWithVariation>();

        private MeasuresWithVariationRepository() {
        }

        public void add(Metric metric, Measure measure, double variationValue) {
            Preconditions.checkArgument((measure.getDeveloper() == null ? 1 : 0) != 0, (String)"%s does not support computing variations of Measures for Developer", (Object[])new Object[]{this.getClass().getSimpleName()});
            MeasureKey measureKey = new MeasureKey(metric.getKey(), null);
            MeasureWithVariation measureWithVariation = this.measuresWithVariations.computeIfAbsent(measureKey, k -> new MeasureWithVariation(metric, measure));
            measureWithVariation.setVariation(variationValue);
        }

        public Collection<MeasureWithVariation> measures() {
            return this.measuresWithVariations.values();
        }
    }

    private class VariationMeasuresVisitor
    extends TypeAwareVisitorAdapter {
        private final DbSession session;
        private final Set<Integer> metricIds;
        private final List<Metric> metrics;

        VariationMeasuresVisitor(DbSession session, List<Metric> metrics) {
            super(CrawlerDepthLimit.reportMaxDepth(Component.Type.DIRECTORY).withViewsMaxDepth(Component.Type.SUBVIEW), ComponentVisitor.Order.PRE_ORDER);
            this.session = session;
            this.metricIds = (Set)metrics.stream().map(Metric::getId).collect(MoreCollectors.toSet());
            this.metrics = metrics;
        }

        @Override
        public void visitAny(Component component) {
            MeasuresWithVariationRepository measuresWithVariationRepository = this.computeMeasuresWithVariations(component);
            this.processMeasuresWithVariation(component, measuresWithVariationRepository);
        }

        private MeasuresWithVariationRepository computeMeasuresWithVariations(Component component) {
            MeasuresWithVariationRepository measuresWithVariationRepository = new MeasuresWithVariationRepository();
            if (ComputeMeasureVariationsStep.this.periodHolder.hasPeriod()) {
                Period period = ComputeMeasureVariationsStep.this.periodHolder.getPeriod();
                List pastMeasures = ComputeMeasureVariationsStep.this.dbClient.measureDao().selectPastMeasures(this.session, component.getUuid(), period.getAnalysisUuid(), this.metricIds);
                this.setVariationMeasures(component, pastMeasures, measuresWithVariationRepository);
            }
            return measuresWithVariationRepository;
        }

        private void setVariationMeasures(Component component, List<PastMeasureDto> pastMeasures, MeasuresWithVariationRepository measuresWithVariationRepository) {
            Map pastMeasuresByMeasureKey = (Map)pastMeasures.stream().collect(MoreCollectors.uniqueIndex(m -> new MeasureKey(ComputeMeasureVariationsStep.this.metricRepository.getById(m.getMetricId()).getKey(), null), Function.identity()));
            for (Metric metric : this.metrics) {
                Optional<Measure> measure = ComputeMeasureVariationsStep.this.measureRepository.getRawMeasure(component, metric);
                if (!measure.isPresent() || ((Measure)measure.get()).hasVariation()) continue;
                PastMeasureDto pastMeasure = (PastMeasureDto)pastMeasuresByMeasureKey.get(new MeasureKey(metric.getKey(), null));
                double pastValue = pastMeasure != null && pastMeasure.hasValue() ? pastMeasure.getValue() : 0.0;
                measuresWithVariationRepository.add(metric, (Measure)measure.get(), this.computeVariation((Measure)measure.get(), pastValue));
            }
        }

        private double computeVariation(Measure measure, double pastValue) {
            switch (measure.getValueType()) {
                case INT: {
                    return (double)measure.getIntValue() - pastValue;
                }
                case LONG: {
                    return (double)measure.getLongValue() - pastValue;
                }
                case DOUBLE: {
                    return measure.getDoubleValue() - pastValue;
                }
                case BOOLEAN: {
                    return (measure.getBooleanValue() ? 1.0 : 0.0) - pastValue;
                }
            }
            throw new IllegalArgumentException(String.format("Unsupported Measure.ValueType on measure '%s'", measure));
        }

        private void processMeasuresWithVariation(Component component, MeasuresWithVariationRepository measuresWithVariationRepository) {
            for (MeasureWithVariation measureWithVariation : measuresWithVariationRepository.measures()) {
                Metric metric = measureWithVariation.getMetric();
                Measure measure = Measure.updatedMeasureBuilder(measureWithVariation.getMeasure()).setVariation(measureWithVariation.getVariation()).create();
                ComputeMeasureVariationsStep.this.measureRepository.update(component, metric, measure);
            }
        }
    }
}

