/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.computation.task.projectanalysis.source.linereader;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.SetMultimap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.db.protobuf.DbFileSources;
import org.sonar.scanner.protocol.output.ScannerReport;
import org.sonar.server.computation.task.projectanalysis.component.Component;
import org.sonar.server.computation.task.projectanalysis.source.linereader.HighlightingLineReader;
import org.sonar.server.computation.task.projectanalysis.source.linereader.LineReader;
import org.sonar.server.computation.task.projectanalysis.source.linereader.RangeOffsetConverter;

public class SymbolsLineReader
implements LineReader {
    private static final Logger LOG = Loggers.get(HighlightingLineReader.class);
    private final Component file;
    private final RangeOffsetConverter rangeOffsetConverter;
    private final Map<ScannerReport.Symbol, Integer> idsBySymbol;
    private final SetMultimap<Integer, ScannerReport.Symbol> symbolsPerLine;
    private boolean areSymbolsValid = true;

    public SymbolsLineReader(Component file, Iterator<ScannerReport.Symbol> symbolIterator, RangeOffsetConverter rangeOffsetConverter) {
        this.file = file;
        this.rangeOffsetConverter = rangeOffsetConverter;
        ArrayList symbols = Lists.newArrayList(symbolIterator);
        Collections.sort(symbols, SymbolsComparator.INSTANCE);
        this.idsBySymbol = SymbolsLineReader.createIdsBySymbolMap(symbols);
        this.symbolsPerLine = SymbolsLineReader.buildSymbolsPerLine(symbols);
    }

    @Override
    public void read(DbFileSources.Line.Builder lineBuilder) {
        if (!this.areSymbolsValid) {
            return;
        }
        try {
            this.processSymbols(lineBuilder);
        }
        catch (RangeOffsetConverter.RangeOffsetConverterException e) {
            this.areSymbolsValid = false;
            LOG.warn(String.format("Inconsistency detected in Symbols data. Symbols will be ignored for file '%s'", this.file.getKey()), (Throwable)e);
        }
    }

    private void processSymbols(DbFileSources.Line.Builder lineBuilder) {
        int line = lineBuilder.getLine();
        ArrayList lineSymbols = new ArrayList(this.symbolsPerLine.get((Object)line));
        Collections.sort(lineSymbols, SymbolsComparator.INSTANCE);
        StringBuilder symbolString = new StringBuilder();
        for (ScannerReport.Symbol lineSymbol : lineSymbols) {
            int symbolId = this.idsBySymbol.get(lineSymbol);
            this.appendSymbol(symbolString, lineSymbol.getDeclaration(), line, symbolId, lineBuilder.getSource());
            for (ScannerReport.TextRange range : lineSymbol.getReferenceList()) {
                this.appendSymbol(symbolString, range, line, symbolId, lineBuilder.getSource());
            }
        }
        if (symbolString.length() > 0) {
            lineBuilder.setSymbols(symbolString.toString());
        }
    }

    private void appendSymbol(StringBuilder lineSymbol, ScannerReport.TextRange range, int line, int symbolId, String sourceLine) {
        String offsets;
        if (SymbolsLineReader.matchLine(range, line) && !(offsets = this.rangeOffsetConverter.offsetToString(range, line, sourceLine.length())).isEmpty()) {
            if (lineSymbol.length() > 0) {
                lineSymbol.append(";");
            }
            lineSymbol.append(offsets).append(",").append(symbolId);
        }
    }

    private static boolean matchLine(ScannerReport.TextRange range, int line) {
        return range.getStartLine() <= line && range.getEndLine() >= line;
    }

    private static Map<ScannerReport.Symbol, Integer> createIdsBySymbolMap(List<ScannerReport.Symbol> symbols) {
        IdentityHashMap<ScannerReport.Symbol, Integer> map = new IdentityHashMap<ScannerReport.Symbol, Integer>(symbols.size());
        int symbolId = 1;
        for (ScannerReport.Symbol symbol : symbols) {
            map.put(symbol, symbolId);
            ++symbolId;
        }
        return map;
    }

    private static SetMultimap<Integer, ScannerReport.Symbol> buildSymbolsPerLine(List<ScannerReport.Symbol> symbols) {
        HashMultimap res = HashMultimap.create();
        for (ScannerReport.Symbol symbol : symbols) {
            SymbolsLineReader.putForTextRange((SetMultimap<Integer, ScannerReport.Symbol>)res, symbol, symbol.getDeclaration());
            for (ScannerReport.TextRange textRange : symbol.getReferenceList()) {
                SymbolsLineReader.putForTextRange((SetMultimap<Integer, ScannerReport.Symbol>)res, symbol, textRange);
            }
        }
        return res;
    }

    private static void putForTextRange(SetMultimap<Integer, ScannerReport.Symbol> res, ScannerReport.Symbol symbol, ScannerReport.TextRange declaration) {
        for (int i = declaration.getStartLine(); i <= declaration.getEndLine(); ++i) {
            res.put((Object)i, (Object)symbol);
        }
    }

    private static enum SymbolsComparator implements Comparator<ScannerReport.Symbol>
    {
        INSTANCE;


        @Override
        public int compare(ScannerReport.Symbol o1, ScannerReport.Symbol o2) {
            if (o1.getDeclaration().getStartLine() == o2.getDeclaration().getStartLine()) {
                return Integer.compare(o1.getDeclaration().getStartOffset(), o2.getDeclaration().getStartOffset());
            }
            return Integer.compare(o1.getDeclaration().getStartLine(), o2.getDeclaration().getStartLine());
        }
    }
}

