/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.computation.task.projectanalysis.source;

import java.util.Optional;
import org.sonar.core.hash.LineRange;
import org.sonar.core.util.CloseableIterator;
import org.sonar.scanner.protocol.output.ScannerReport;
import org.sonar.server.computation.task.projectanalysis.batch.BatchReportReader;
import org.sonar.server.computation.task.projectanalysis.component.Component;

public class SignificantCodeRepository {
    private final BatchReportReader reportReader;

    public SignificantCodeRepository(BatchReportReader reportReader) {
        this.reportReader = reportReader;
    }

    public Optional<LineRange[]> getRangesPerLine(Component component) {
        int numLines = component.getFileAttributes().getLines();
        Optional<CloseableIterator<ScannerReport.LineSgnificantCode>> significantCode = this.reportReader.readComponentSignificantCode(component.getReportAttributes().getRef());
        return significantCode.map(s -> SignificantCodeRepository.toArray((CloseableIterator<ScannerReport.LineSgnificantCode>)s, numLines));
    }

    private static LineRange[] toArray(CloseableIterator<ScannerReport.LineSgnificantCode> lineRanges, int numLines) {
        LineRange[] ranges = new LineRange[numLines];
        ScannerReport.LineSgnificantCode currentLine = null;
        for (int i = 0; i < numLines; ++i) {
            if (currentLine == null) {
                if (!lineRanges.hasNext()) break;
                currentLine = (ScannerReport.LineSgnificantCode)lineRanges.next();
            }
            if (currentLine.getLine() != i + 1) continue;
            ranges[i] = new LineRange(currentLine.getStartOffset(), currentLine.getEndOffset());
            currentLine = null;
        }
        return ranges;
    }
}

