/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.computation.task.projectanalysis.source;

import com.google.common.base.Joiner;
import java.util.Iterator;
import java.util.List;
import org.sonar.core.hash.SourceHashComputer;
import org.sonar.db.protobuf.DbFileSources;
import org.sonar.server.computation.task.projectanalysis.source.SourceLinesHashRepositoryImpl;
import org.sonar.server.computation.task.projectanalysis.source.linereader.LineReader;

public class ComputeFileSourceData {
    private static final Joiner LINE_RETURN_JOINER = Joiner.on((char)'\n');
    private final List<LineReader> lineReaders;
    private final Iterator<String> linesIterator;
    private final SourceHashComputer sourceHashComputer;
    private final SourceLinesHashRepositoryImpl.LineHashesComputer lineHashesComputer;

    public ComputeFileSourceData(Iterator<String> sourceLinesIterator, List<LineReader> dataLineReaders, SourceLinesHashRepositoryImpl.LineHashesComputer lineHashesComputer) {
        this.lineReaders = dataLineReaders;
        this.linesIterator = sourceLinesIterator;
        this.lineHashesComputer = lineHashesComputer;
        this.sourceHashComputer = new SourceHashComputer();
    }

    public Data compute() {
        DbFileSources.Data.Builder fileSourceBuilder = DbFileSources.Data.newBuilder();
        int currentLine = 0;
        while (this.linesIterator.hasNext()) {
            this.read(fileSourceBuilder, ++currentLine, this.linesIterator.next(), this.linesIterator.hasNext());
        }
        return new Data(fileSourceBuilder.build(), this.lineHashesComputer.getResult(), this.sourceHashComputer.getHash());
    }

    private void read(DbFileSources.Data.Builder fileSourceBuilder, int currentLine, String lineSource, boolean hasNextLine) {
        this.sourceHashComputer.addLine(lineSource, hasNextLine);
        this.lineHashesComputer.addLine(lineSource);
        DbFileSources.Line.Builder lineBuilder = fileSourceBuilder.addLinesBuilder().setSource(lineSource).setLine(currentLine);
        for (LineReader lineReader : this.lineReaders) {
            lineReader.read(lineBuilder);
        }
    }

    public static class Data {
        private final DbFileSources.Data fileSourceData;
        private final List<String> lineHashes;
        private final String srcHash;

        private Data(DbFileSources.Data fileSourceData, List<String> lineHashes, String srcHash) {
            this.fileSourceData = fileSourceData;
            this.lineHashes = lineHashes;
            this.srcHash = srcHash;
        }

        public String getSrcHash() {
            return this.srcHash;
        }

        public List<String> getLineHashes() {
            return this.lineHashes;
        }

        public DbFileSources.Data getFileSourceData() {
            return this.fileSourceData;
        }
    }
}

