/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.computation.task.projectanalysis.qualitygate;

import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import java.util.Objects;
import java.util.Set;
import javax.annotation.concurrent.Immutable;
import org.sonar.server.computation.task.projectanalysis.qualitygate.Condition;

@Immutable
public class QualityGate {
    private final long id;
    private final String name;
    private final Set<Condition> conditions;

    public QualityGate(long id, String name, Iterable<Condition> conditions) {
        this.id = id;
        this.name = Objects.requireNonNull(name);
        this.conditions = FluentIterable.from(conditions).filter(Predicates.notNull()).toSet();
    }

    public long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public Set<Condition> getConditions() {
        return this.conditions;
    }
}

