/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.computation.task.projectanalysis.qualitygate;

import com.google.common.base.MoreObjects;
import java.util.Objects;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.sonar.server.computation.task.projectanalysis.metric.Metric;

@Immutable
public class Condition {
    private final Metric metric;
    private final Operator operator;
    @CheckForNull
    private final String warningThreshold;
    @CheckForNull
    private final String errorThreshold;
    private final boolean hasPeriod;

    public Condition(Metric metric, String operator, @Nullable String errorThreshold, @Nullable String warningThreshold, boolean hasPeriod) {
        this.metric = Objects.requireNonNull(metric);
        this.operator = Condition.parseFromDbValue(Objects.requireNonNull(operator));
        this.hasPeriod = hasPeriod;
        this.errorThreshold = errorThreshold;
        this.warningThreshold = warningThreshold;
    }

    private static Operator parseFromDbValue(String str) {
        for (Operator operator : Operator.values()) {
            if (!operator.dbValue.equals(str)) continue;
            return operator;
        }
        throw new IllegalArgumentException(String.format("Unsupported operator value: '%s'", str));
    }

    public Metric getMetric() {
        return this.metric;
    }

    public boolean hasPeriod() {
        return this.hasPeriod;
    }

    public Operator getOperator() {
        return this.operator;
    }

    @CheckForNull
    public String getWarningThreshold() {
        return this.warningThreshold;
    }

    @CheckForNull
    public String getErrorThreshold() {
        return this.errorThreshold;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Condition that = (Condition)o;
        return Objects.equals(this.metric, that.metric) && Objects.equals(this.hasPeriod, that.hasPeriod);
    }

    public int hashCode() {
        return Objects.hash(this.metric, this.hasPeriod);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("metric", (Object)this.metric).add("hasPeriod", this.hasPeriod).add("operator", (Object)this.operator).add("warningThreshold", (Object)this.warningThreshold).add("errorThreshold", (Object)this.errorThreshold).toString();
    }

    public static enum Operator {
        EQUALS("EQ"),
        NOT_EQUALS("NE"),
        GREATER_THAN("GT"),
        LESS_THAN("LT");

        private final String dbValue;

        private Operator(String dbValue) {
            this.dbValue = dbValue;
        }

        public String getDbValue() {
            return this.dbValue;
        }
    }
}

