/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.computation.task.projectanalysis.measure.qualitygatedetails;

import com.google.common.collect.FluentIterable;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;
import org.sonar.server.computation.task.projectanalysis.measure.Measure;
import org.sonar.server.computation.task.projectanalysis.measure.qualitygatedetails.EvaluatedCondition;
import org.sonar.server.computation.task.projectanalysis.qualitygate.Condition;

@Immutable
public class QualityGateDetailsData {
    private static final String FIELD_LEVEL = "level";
    private static final String FIELD_IGNORED_CONDITIONS = "ignoredConditions";
    private final Measure.Level level;
    private final List<EvaluatedCondition> conditions;
    private final boolean ignoredConditions;

    public QualityGateDetailsData(Measure.Level level, Iterable<EvaluatedCondition> conditions, boolean ignoredConditions) {
        this.level = Objects.requireNonNull(level);
        this.conditions = FluentIterable.from(conditions).toList();
        this.ignoredConditions = ignoredConditions;
    }

    public String toJson() {
        JsonObject details = new JsonObject();
        details.addProperty(FIELD_LEVEL, this.level.toString());
        JsonArray conditionResults = new JsonArray();
        for (EvaluatedCondition condition : this.conditions) {
            conditionResults.add((JsonElement)QualityGateDetailsData.toJson(condition));
        }
        details.add("conditions", (JsonElement)conditionResults);
        details.addProperty(FIELD_IGNORED_CONDITIONS, Boolean.valueOf(this.ignoredConditions));
        return details.toString();
    }

    private static JsonObject toJson(EvaluatedCondition evaluatedCondition) {
        Condition condition = evaluatedCondition.getCondition();
        JsonObject result = new JsonObject();
        result.addProperty("metric", condition.getMetric().getKey());
        result.addProperty("op", condition.getOperator().getDbValue());
        if (condition.hasPeriod()) {
            result.addProperty("period", (Number)1);
        }
        if (condition.getWarningThreshold() != null) {
            result.addProperty("warning", condition.getWarningThreshold());
        }
        if (condition.getErrorThreshold() != null) {
            result.addProperty("error", condition.getErrorThreshold());
        }
        result.addProperty("actual", evaluatedCondition.getActualValue());
        result.addProperty(FIELD_LEVEL, evaluatedCondition.getLevel().name());
        return result;
    }
}

