/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.computation.task.projectanalysis.measure;

import javax.annotation.CheckForNull;
import org.sonar.db.measure.LiveMeasureDto;
import org.sonar.db.measure.MeasureDto;
import org.sonar.server.computation.task.projectanalysis.analysis.AnalysisMetadataHolder;
import org.sonar.server.computation.task.projectanalysis.component.Component;
import org.sonar.server.computation.task.projectanalysis.component.TreeRootHolder;
import org.sonar.server.computation.task.projectanalysis.measure.Measure;
import org.sonar.server.computation.task.projectanalysis.measure.QualityGateStatus;
import org.sonar.server.computation.task.projectanalysis.metric.Metric;

public class MeasureToMeasureDto {
    private final AnalysisMetadataHolder analysisMetadataHolder;
    private final TreeRootHolder treeRootHolder;

    public MeasureToMeasureDto(AnalysisMetadataHolder analysisMetadataHolder, TreeRootHolder treeRootHolder) {
        this.analysisMetadataHolder = analysisMetadataHolder;
        this.treeRootHolder = treeRootHolder;
    }

    public MeasureDto toMeasureDto(Measure measure, Metric metric, Component component) {
        MeasureDto out = new MeasureDto();
        out.setMetricId(metric.getId());
        out.setComponentUuid(component.getUuid());
        out.setAnalysisUuid(this.analysisMetadataHolder.getUuid());
        if (measure.hasVariation()) {
            out.setVariation(Double.valueOf(measure.getVariation()));
        }
        if (measure.hasQualityGateStatus()) {
            MeasureToMeasureDto.setAlert(out, measure.getQualityGateStatus());
        }
        out.setValue(MeasureToMeasureDto.valueAsDouble(measure));
        out.setData(MeasureToMeasureDto.data(measure));
        return out;
    }

    public LiveMeasureDto toLiveMeasureDto(Measure measure, Metric metric, Component component) {
        LiveMeasureDto out = new LiveMeasureDto();
        out.setMetricId(metric.getId());
        out.setComponentUuid(component.getUuid());
        out.setProjectUuid(this.treeRootHolder.getRoot().getUuid());
        if (measure.hasVariation()) {
            out.setVariation(Double.valueOf(measure.getVariation()));
        }
        out.setValue(MeasureToMeasureDto.valueAsDouble(measure));
        out.setData(MeasureToMeasureDto.data(measure));
        return out;
    }

    private static void setAlert(MeasureDto measureDto, QualityGateStatus qualityGateStatus) {
        measureDto.setAlertStatus(qualityGateStatus.getStatus().name());
        measureDto.setAlertText(qualityGateStatus.getText());
    }

    private static String data(Measure in) {
        switch (in.getValueType()) {
            case NO_VALUE: 
            case BOOLEAN: 
            case INT: 
            case LONG: 
            case DOUBLE: {
                return in.getData();
            }
            case STRING: {
                return in.getStringValue();
            }
            case LEVEL: {
                return in.getLevelValue().name();
            }
        }
        return null;
    }

    @CheckForNull
    private static Double valueAsDouble(Measure measure) {
        switch (measure.getValueType()) {
            case BOOLEAN: {
                return measure.getBooleanValue() ? 1.0 : 0.0;
            }
            case INT: {
                return measure.getIntValue();
            }
            case LONG: {
                return measure.getLongValue();
            }
            case DOUBLE: {
                return measure.getDoubleValue();
            }
        }
        return null;
    }
}

