/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.computation.task.projectanalysis.issue;

import java.util.Collection;
import java.util.Map;
import org.sonar.core.issue.DefaultIssue;
import org.sonar.core.issue.tracking.SimpleTracker;
import org.sonar.core.issue.tracking.Tracking;
import org.sonar.server.computation.task.projectanalysis.component.Component;
import org.sonar.server.computation.task.projectanalysis.issue.IssueLifecycle;
import org.sonar.server.computation.task.projectanalysis.issue.ShortBranchIssue;
import org.sonar.server.computation.task.projectanalysis.issue.ShortBranchIssuesLoader;

public class ShortBranchIssueMerger {
    private final ShortBranchIssuesLoader shortBranchIssuesLoader;
    private final SimpleTracker<DefaultIssue, ShortBranchIssue> tracker;
    private final IssueLifecycle issueLifecycle;

    public ShortBranchIssueMerger(ShortBranchIssuesLoader resolvedShortBranchIssuesLoader, IssueLifecycle issueLifecycle) {
        this(resolvedShortBranchIssuesLoader, (SimpleTracker<DefaultIssue, ShortBranchIssue>)new SimpleTracker(), issueLifecycle);
    }

    public ShortBranchIssueMerger(ShortBranchIssuesLoader shortBranchIssuesLoader, SimpleTracker<DefaultIssue, ShortBranchIssue> tracker, IssueLifecycle issueLifecycle) {
        this.shortBranchIssuesLoader = shortBranchIssuesLoader;
        this.tracker = tracker;
        this.issueLifecycle = issueLifecycle;
    }

    public void tryMerge(Component component, Collection<DefaultIssue> newIssues) {
        Collection<ShortBranchIssue> shortBranchIssues = this.shortBranchIssuesLoader.loadCandidateIssuesForMergingInTargetBranch(component);
        Tracking tracking = this.tracker.track(newIssues, shortBranchIssues);
        Map matchedRaws = tracking.getMatchedRaws();
        Map<ShortBranchIssue, DefaultIssue> defaultIssues = this.shortBranchIssuesLoader.loadDefaultIssuesWithChanges(matchedRaws.values());
        for (Map.Entry e : matchedRaws.entrySet()) {
            ShortBranchIssue issue = (ShortBranchIssue)e.getValue();
            this.issueLifecycle.mergeConfirmedOrResolvedFromShortLivingBranch((DefaultIssue)e.getKey(), defaultIssues.get(issue), issue.getBranchName());
        }
    }
}

