/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.computation.task.projectanalysis.issue;

import java.util.ArrayList;
import java.util.List;
import org.sonar.core.issue.DefaultIssue;
import org.sonar.server.computation.task.projectanalysis.component.Component;
import org.sonar.server.computation.task.projectanalysis.issue.IssueVisitor;
import org.sonar.server.computation.task.projectanalysis.issue.MutableComponentIssuesRepository;

public class IssuesRepositoryVisitor
extends IssueVisitor {
    private final MutableComponentIssuesRepository componentIssuesRepository;
    private final List<DefaultIssue> componentIssues = new ArrayList<DefaultIssue>();

    public IssuesRepositoryVisitor(MutableComponentIssuesRepository componentIssuesRepository) {
        this.componentIssuesRepository = componentIssuesRepository;
    }

    @Override
    public void beforeComponent(Component component) {
        this.componentIssues.clear();
    }

    @Override
    public void onIssue(Component component, DefaultIssue issue) {
        this.componentIssues.add(issue);
    }

    @Override
    public void afterComponent(Component component) {
        this.componentIssuesRepository.setIssues(component, this.componentIssues);
    }
}

