/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.computation.task.projectanalysis.issue;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.sonar.api.rule.RuleKey;
import org.sonar.api.rule.RuleStatus;
import org.sonar.core.issue.DefaultIssue;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.issue.IssueChangeDto;
import org.sonar.db.issue.IssueDto;
import org.sonar.db.issue.IssueMapper;
import org.sonar.server.computation.task.projectanalysis.issue.Rule;
import org.sonar.server.computation.task.projectanalysis.issue.RuleRepository;
import org.sonar.server.computation.task.projectanalysis.qualityprofile.ActiveRulesHolder;

public class ComponentIssuesLoader {
    private final DbClient dbClient;
    private final RuleRepository ruleRepository;
    private final ActiveRulesHolder activeRulesHolder;

    public ComponentIssuesLoader(DbClient dbClient, RuleRepository ruleRepository, ActiveRulesHolder activeRulesHolder) {
        this.activeRulesHolder = activeRulesHolder;
        this.dbClient = dbClient;
        this.ruleRepository = ruleRepository;
    }

    public List<DefaultIssue> loadForComponentUuid(String componentUuid) {
        try (DbSession dbSession = this.dbClient.openSession(false);){
            List<DefaultIssue> list = this.loadForComponentUuid(componentUuid, dbSession);
            return list;
        }
    }

    public List<DefaultIssue> loadForComponentUuidWithChanges(String componentUuid) {
        try (DbSession dbSession = this.dbClient.openSession(false);){
            List<DefaultIssue> result = this.loadForComponentUuid(componentUuid, dbSession);
            Map<String, List<IssueChangeDto>> changeDtoByIssueKey = this.dbClient.issueChangeDao().selectByIssueKeys(dbSession, (Collection)result.stream().map(DefaultIssue::key).collect(Collectors.toList())).stream().collect(Collectors.groupingBy(IssueChangeDto::getIssueKey));
            List<DefaultIssue> list = result.stream().peek(i -> ComponentIssuesLoader.setChanges(changeDtoByIssueKey, i)).collect(Collectors.toList());
            return list;
        }
    }

    private List<DefaultIssue> loadForComponentUuid(String componentUuid, DbSession dbSession) {
        ArrayList<DefaultIssue> result = new ArrayList<DefaultIssue>();
        ((IssueMapper)dbSession.getMapper(IssueMapper.class)).scrollNonClosedByComponentUuid(componentUuid, resultContext -> {
            DefaultIssue issue = ((IssueDto)resultContext.getResultObject()).toDefaultIssue();
            Rule rule = this.ruleRepository.getByKey(issue.ruleKey());
            if (!rule.isExternal() && !this.isActive(issue.ruleKey()) || rule.getStatus() == RuleStatus.REMOVED) {
                issue.setOnDisabledRule(true);
                issue.setBeingClosed(true);
            }
            issue.setSelectedAt(Long.valueOf(System.currentTimeMillis()));
            result.add(issue);
        });
        return result;
    }

    public static void setChanges(Map<String, List<IssueChangeDto>> changeDtoByIssueKey, DefaultIssue i) {
        changeDtoByIssueKey.computeIfAbsent(i.key(), k -> Collections.emptyList()).forEach(c -> {
            switch (c.getChangeType()) {
                case "diff": {
                    i.addChange(c.toFieldDiffs());
                    break;
                }
                case "comment": {
                    i.addComment(c.toComment());
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknow change type: " + c.getChangeType());
                }
            }
        });
    }

    private boolean isActive(RuleKey ruleKey) {
        return this.activeRulesHolder.get(ruleKey).isPresent();
    }
}

