/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.computation.task.projectanalysis.formula.counter;

import com.google.common.base.Optional;
import java.util.Objects;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.server.computation.task.projectanalysis.formula.CounterInitializationContext;
import org.sonar.server.computation.task.projectanalysis.formula.counter.SumCounter;
import org.sonar.server.computation.task.projectanalysis.measure.Measure;

public class LongSumCounter
implements SumCounter<Long, LongSumCounter> {
    private final String metricKey;
    @CheckForNull
    private final Long defaultInputValue;
    private long value = 0L;
    private boolean initialized = false;

    public LongSumCounter(String metricKey) {
        this(metricKey, null);
    }

    public LongSumCounter(String metricKey, @Nullable Long defaultInputValue) {
        this.metricKey = Objects.requireNonNull(metricKey, "metricKey can not be null");
        this.defaultInputValue = defaultInputValue;
    }

    @Override
    public void aggregate(LongSumCounter counter) {
        if (counter.getValue().isPresent()) {
            this.addValue((Long)counter.getValue().get());
        }
    }

    @Override
    public void initialize(CounterInitializationContext context) {
        Optional<Measure> measureOptional = context.getMeasure(this.metricKey);
        if (measureOptional.isPresent()) {
            this.addValue(((Measure)measureOptional.get()).getLongValue());
        } else if (this.defaultInputValue != null) {
            this.addValue(this.defaultInputValue);
        }
    }

    private void addValue(long newValue) {
        this.initialized = true;
        this.value += newValue;
    }

    @Override
    public Optional<Long> getValue() {
        if (this.initialized) {
            return Optional.of((Object)this.value);
        }
        return Optional.absent();
    }
}

