/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.computation.task.projectanalysis.filemove;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.apache.ibatis.session.ResultContext;
import org.apache.ibatis.session.ResultHandler;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.core.util.logs.Profiler;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.component.FileMoveRowDto;
import org.sonar.db.source.LineHashesWithKeyDto;
import org.sonar.server.computation.task.projectanalysis.analysis.AnalysisMetadataHolder;
import org.sonar.server.computation.task.projectanalysis.component.Component;
import org.sonar.server.computation.task.projectanalysis.component.ComponentVisitor;
import org.sonar.server.computation.task.projectanalysis.component.CrawlerDepthLimit;
import org.sonar.server.computation.task.projectanalysis.component.DepthTraversalTypeAwareCrawler;
import org.sonar.server.computation.task.projectanalysis.component.TreeRootHolder;
import org.sonar.server.computation.task.projectanalysis.component.TypeAwareVisitorAdapter;
import org.sonar.server.computation.task.projectanalysis.filemove.FileSimilarity;
import org.sonar.server.computation.task.projectanalysis.filemove.Match;
import org.sonar.server.computation.task.projectanalysis.filemove.MatchesByScore;
import org.sonar.server.computation.task.projectanalysis.filemove.MovedFilesRepository;
import org.sonar.server.computation.task.projectanalysis.filemove.MutableMovedFilesRepository;
import org.sonar.server.computation.task.projectanalysis.filemove.ScoreMatrix;
import org.sonar.server.computation.task.projectanalysis.filemove.ScoreMatrixDumper;
import org.sonar.server.computation.task.projectanalysis.source.SourceLinesHashRepository;
import org.sonar.server.computation.task.step.ComputationStep;

public class FileMoveDetectionStep
implements ComputationStep {
    protected static final int MIN_REQUIRED_SCORE = 85;
    private static final Logger LOG = Loggers.get(FileMoveDetectionStep.class);
    private static final Comparator<ScoreMatrix.ScoreFile> SCORE_FILE_COMPARATOR = (o1, o2) -> -1 * Integer.compare(o1.getLineCount(), o2.getLineCount());
    private static final double LOWER_BOUND_RATIO = 0.84;
    private static final double UPPER_BOUND_RATIO = 1.18;
    private final AnalysisMetadataHolder analysisMetadataHolder;
    private final TreeRootHolder rootHolder;
    private final DbClient dbClient;
    private final FileSimilarity fileSimilarity;
    private final MutableMovedFilesRepository movedFilesRepository;
    private final SourceLinesHashRepository sourceLinesHash;
    private final ScoreMatrixDumper scoreMatrixDumper;

    public FileMoveDetectionStep(AnalysisMetadataHolder analysisMetadataHolder, TreeRootHolder rootHolder, DbClient dbClient, FileSimilarity fileSimilarity, MutableMovedFilesRepository movedFilesRepository, SourceLinesHashRepository sourceLinesHash, ScoreMatrixDumper scoreMatrixDumper) {
        this.analysisMetadataHolder = analysisMetadataHolder;
        this.rootHolder = rootHolder;
        this.dbClient = dbClient;
        this.fileSimilarity = fileSimilarity;
        this.movedFilesRepository = movedFilesRepository;
        this.sourceLinesHash = sourceLinesHash;
        this.scoreMatrixDumper = scoreMatrixDumper;
    }

    @Override
    public String getDescription() {
        return "Detect file moves";
    }

    @Override
    public void execute() {
        if (this.analysisMetadataHolder.isFirstAnalysis()) {
            LOG.debug("First analysis. Do nothing.");
            return;
        }
        Profiler p = Profiler.createIfTrace((Logger)LOG);
        p.start();
        Map<String, DbComponent> dbFilesByKey = this.getDbFilesByKey();
        if (dbFilesByKey.isEmpty()) {
            LOG.debug("Previous snapshot has no file. Do nothing.");
            return;
        }
        Map<String, Component> reportFilesByKey = FileMoveDetectionStep.getReportFilesByKey(this.rootHolder.getRoot());
        if (reportFilesByKey.isEmpty()) {
            LOG.debug("No files in report. Do nothing.");
            return;
        }
        ImmutableSet addedFileKeys = ImmutableSet.copyOf((Collection)Sets.difference(reportFilesByKey.keySet(), dbFilesByKey.keySet()));
        ImmutableSet removedFileKeys = ImmutableSet.copyOf((Collection)Sets.difference(dbFilesByKey.keySet(), reportFilesByKey.keySet()));
        if (addedFileKeys.isEmpty() || removedFileKeys.isEmpty()) {
            LOG.debug("Either no files added or no files removed. Do nothing.");
            return;
        }
        Map<String, FileSimilarity.File> reportFileSourcesByKey = this.getReportFileSourcesByKey(reportFilesByKey, (Set<String>)addedFileKeys);
        p.stopTrace("loaded");
        p.start();
        ScoreMatrix scoreMatrix = this.computeScoreMatrix(dbFilesByKey, (Set<String>)removedFileKeys, reportFileSourcesByKey);
        p.stopTrace("Score matrix computed");
        this.scoreMatrixDumper.dumpAsCsv(scoreMatrix);
        if (scoreMatrix.getMaxScore() < 85) {
            LOG.debug("max score in matrix is less than min required score (%s). Do nothing.", (Object)85);
            return;
        }
        p.start();
        MatchesByScore matchesByScore = MatchesByScore.create(scoreMatrix);
        ElectedMatches electedMatches = FileMoveDetectionStep.electMatches((Set<String>)removedFileKeys, reportFileSourcesByKey, matchesByScore);
        p.stopTrace("Matches elected");
        this.registerMatches(dbFilesByKey, reportFilesByKey, electedMatches);
    }

    private void registerMatches(Map<String, DbComponent> dbFilesByKey, Map<String, Component> reportFilesByKey, ElectedMatches electedMatches) {
        LOG.debug("{} files moves found", (Object)electedMatches.size());
        for (Match validatedMatch : electedMatches) {
            this.movedFilesRepository.setOriginalFile(reportFilesByKey.get(validatedMatch.getReportKey()), FileMoveDetectionStep.toOriginalFile(dbFilesByKey.get(validatedMatch.getDbKey())));
            LOG.trace("File move found: {}", (Object)validatedMatch);
        }
    }

    private Map<String, DbComponent> getDbFilesByKey() {
        try (DbSession dbSession = this.dbClient.openSession(false);){
            ImmutableList.Builder builder = ImmutableList.builder();
            this.dbClient.componentDao().scrollAllFilesForFileMove(dbSession, this.rootHolder.getRoot().getUuid(), resultContext -> {
                FileMoveRowDto row = (FileMoveRowDto)resultContext.getResultObject();
                builder.add((Object)new DbComponent(row.getId(), row.getKey(), row.getUuid(), row.getPath(), row.getLineCount()));
            });
            Map map = (Map)builder.build().stream().collect(MoreCollectors.uniqueIndex(DbComponent::getKey));
            return map;
        }
    }

    private static Map<String, Component> getReportFilesByKey(Component root) {
        final ImmutableMap.Builder builder = ImmutableMap.builder();
        new DepthTraversalTypeAwareCrawler(new TypeAwareVisitorAdapter(CrawlerDepthLimit.FILE, ComponentVisitor.Order.POST_ORDER){

            @Override
            public void visitFile(Component file) {
                builder.put((Object)file.getKey(), (Object)file);
            }
        }).visit(root);
        return builder.build();
    }

    private Map<String, FileSimilarity.File> getReportFileSourcesByKey(Map<String, Component> reportFilesByKey, Set<String> addedFileKeys) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (String fileKey : addedFileKeys) {
            Component component = reportFilesByKey.get(fileKey);
            FileSimilarity.LazyFileImpl file = new FileSimilarity.LazyFileImpl(component.getReportAttributes().getPath(), () -> this.getReportFileLineHashes(component), component.getFileAttributes().getLines());
            builder.put((Object)fileKey, (Object)file);
        }
        return builder.build();
    }

    private List<String> getReportFileLineHashes(Component component) {
        return this.sourceLinesHash.getLineHashesMatchingDBVersion(component);
    }

    private ScoreMatrix computeScoreMatrix(Map<String, DbComponent> dtosByKey, Set<String> removedFileKeys, Map<String, FileSimilarity.File> newFileSourcesByKey) {
        ScoreMatrix.ScoreFile[] newFiles = (ScoreMatrix.ScoreFile[])newFileSourcesByKey.entrySet().stream().map(e -> new ScoreMatrix.ScoreFile((String)e.getKey(), ((FileSimilarity.File)e.getValue()).getLineCount())).toArray(ScoreMatrix.ScoreFile[]::new);
        ScoreMatrix.ScoreFile[] removedFiles = (ScoreMatrix.ScoreFile[])removedFileKeys.stream().map(key -> {
            DbComponent dbComponent = (DbComponent)dtosByKey.get(key);
            return new ScoreMatrix.ScoreFile(dbComponent.getKey(), dbComponent.getLineCount());
        }).toArray(ScoreMatrix.ScoreFile[]::new);
        Arrays.sort(newFiles, SCORE_FILE_COMPARATOR);
        Arrays.sort(removedFiles, SCORE_FILE_COMPARATOR);
        int[][] scoreMatrix = new int[removedFiles.length][newFiles.length];
        int lastNewFileIndex = newFiles.length - 1;
        HashMap<String, Integer> removedFilesIndexes = new HashMap<String, Integer>(removedFileKeys.size());
        for (int removeFileIndex = 0; removeFileIndex < removedFiles.length; ++removeFileIndex) {
            ScoreMatrix.ScoreFile removedFile = removedFiles[removeFileIndex];
            int lowerBound = (int)Math.floor((double)removedFile.getLineCount() * 0.84);
            int upperBound = (int)Math.ceil((double)removedFile.getLineCount() * 1.18);
            if (newFiles[0].getLineCount() <= lowerBound || newFiles[lastNewFileIndex].getLineCount() >= upperBound) continue;
            removedFilesIndexes.put(removedFile.getFileKey(), removeFileIndex);
        }
        LineHashesWithKeyDtoResultHandler rowHandler = new LineHashesWithKeyDtoResultHandler(removedFilesIndexes, removedFiles, newFiles, newFileSourcesByKey, scoreMatrix);
        try (DbSession dbSession = this.dbClient.openSession(false);){
            this.dbClient.fileSourceDao().scrollLineHashes(dbSession, removedFilesIndexes.keySet(), (ResultHandler)rowHandler);
        }
        return new ScoreMatrix(removedFiles, newFiles, scoreMatrix, rowHandler.getMaxScore());
    }

    private static ElectedMatches electMatches(Set<String> dbFileKeys, Map<String, FileSimilarity.File> reportFileSourcesByKey, MatchesByScore matchesByScore) {
        ElectedMatches electedMatches = new ElectedMatches(matchesByScore, dbFileKeys, reportFileSourcesByKey);
        ArrayListMultimap matchesPerFileForScore = ArrayListMultimap.create();
        matchesByScore.forEach(arg_0 -> FileMoveDetectionStep.lambda$electMatches$7(electedMatches, (Multimap)matchesPerFileForScore, arg_0));
        return electedMatches;
    }

    private static void electMatches(@Nullable List<Match> matches, ElectedMatches electedMatches, Multimap<String, Match> matchesPerFileForScore) {
        if (matches == null) {
            return;
        }
        List<Match> matchesToValidate = electedMatches.filter(matches);
        if (matchesToValidate.isEmpty()) {
            return;
        }
        if (matchesToValidate.size() == 1) {
            Match match = matchesToValidate.get(0);
            electedMatches.add(match);
        } else {
            matchesPerFileForScore.clear();
            for (Match match : matchesToValidate) {
                matchesPerFileForScore.put((Object)match.getDbKey(), (Object)match);
                matchesPerFileForScore.put((Object)match.getReportKey(), (Object)match);
            }
            for (Match match : matchesToValidate) {
                int dbFileMatchesCount = matchesPerFileForScore.get((Object)match.getDbKey()).size();
                int reportFileMatchesCount = matchesPerFileForScore.get((Object)match.getReportKey()).size();
                if (dbFileMatchesCount != 1 || reportFileMatchesCount != 1) continue;
                electedMatches.add(match);
            }
        }
    }

    private static MovedFilesRepository.OriginalFile toOriginalFile(DbComponent dbComponent) {
        return new MovedFilesRepository.OriginalFile(dbComponent.getId(), dbComponent.getUuid(), dbComponent.getKey());
    }

    private static /* synthetic */ void lambda$electMatches$7(ElectedMatches electedMatches, Multimap matchesPerFileForScore, List matches) {
        FileMoveDetectionStep.electMatches(matches, electedMatches, (Multimap<String, Match>)matchesPerFileForScore);
    }

    private static class ElectedMatches
    implements Iterable<Match> {
        private final List<Match> matches;
        private final Set<String> matchedFileKeys;

        public ElectedMatches(MatchesByScore matchesByScore, Set<String> dbFileKeys, Map<String, FileSimilarity.File> reportFileSourcesByKey) {
            this.matches = new ArrayList<Match>(matchesByScore.getSize());
            this.matchedFileKeys = new HashSet<String>(dbFileKeys.size() + reportFileSourcesByKey.size());
        }

        public void add(Match match) {
            this.matches.add(match);
            this.matchedFileKeys.add(match.getDbKey());
            this.matchedFileKeys.add(match.getReportKey());
        }

        public List<Match> filter(Iterable<Match> matches) {
            return FluentIterable.from(matches).filter(this::notAlreadyMatched).toList();
        }

        private boolean notAlreadyMatched(Match input) {
            return !this.matchedFileKeys.contains(input.getDbKey()) && !this.matchedFileKeys.contains(input.getReportKey());
        }

        @Override
        public Iterator<Match> iterator() {
            return this.matches.iterator();
        }

        public int size() {
            return this.matches.size();
        }
    }

    @Immutable
    private static final class DbComponent {
        private final long id;
        private final String key;
        private final String uuid;
        private final String path;
        private final int lineCount;

        private DbComponent(long id, String key, String uuid, String path, int lineCount) {
            this.id = id;
            this.key = key;
            this.uuid = uuid;
            this.path = path;
            this.lineCount = lineCount;
        }

        public long getId() {
            return this.id;
        }

        public String getKey() {
            return this.key;
        }

        public String getUuid() {
            return this.uuid;
        }

        public String getPath() {
            return this.path;
        }

        public int getLineCount() {
            return this.lineCount;
        }
    }

    private final class LineHashesWithKeyDtoResultHandler
    implements ResultHandler<LineHashesWithKeyDto> {
        private final Map<String, Integer> removedFilesIndexes;
        private final ScoreMatrix.ScoreFile[] removedFiles;
        private final ScoreMatrix.ScoreFile[] newFiles;
        private final Map<String, FileSimilarity.File> newFileSourcesByKey;
        private final int[][] scoreMatrix;
        private int maxScore;

        private LineHashesWithKeyDtoResultHandler(Map<String, Integer> removedFilesIndexes, ScoreMatrix.ScoreFile[] removedFiles, ScoreMatrix.ScoreFile[] newFiles, Map<String, FileSimilarity.File> newFileSourcesByKey, int[][] scoreMatrix) {
            this.removedFilesIndexes = removedFilesIndexes;
            this.removedFiles = removedFiles;
            this.newFiles = newFiles;
            this.newFileSourcesByKey = newFileSourcesByKey;
            this.scoreMatrix = scoreMatrix;
        }

        public void handleResult(ResultContext<? extends LineHashesWithKeyDto> resultContext) {
            LineHashesWithKeyDto lineHashesDto = (LineHashesWithKeyDto)resultContext.getResultObject();
            if (lineHashesDto.getPath() == null) {
                return;
            }
            int removeFileIndex = this.removedFilesIndexes.get(lineHashesDto.getKey());
            ScoreMatrix.ScoreFile removedFile = this.removedFiles[removeFileIndex];
            int lowerBound = (int)Math.floor((double)removedFile.getLineCount() * 0.84);
            int upperBound = (int)Math.ceil((double)removedFile.getLineCount() * 1.18);
            for (int newFileIndex = 0; newFileIndex < this.newFiles.length; ++newFileIndex) {
                int score;
                ScoreMatrix.ScoreFile newFile = this.newFiles[newFileIndex];
                if (newFile.getLineCount() >= upperBound) continue;
                if (newFile.getLineCount() <= lowerBound) break;
                FileSimilarity.FileImpl fileInDb = new FileSimilarity.FileImpl(lineHashesDto.getPath(), lineHashesDto.getLineHashes());
                FileSimilarity.File unmatchedFile = this.newFileSourcesByKey.get(newFile.getFileKey());
                this.scoreMatrix[removeFileIndex][newFileIndex] = score = FileMoveDetectionStep.this.fileSimilarity.score(fileInDb, unmatchedFile);
                if (score <= this.maxScore) continue;
                this.maxScore = score;
            }
        }

        int getMaxScore() {
            return this.maxScore;
        }
    }
}

