/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.computation.task.projectanalysis.duplication;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Ordering;
import java.util.Comparator;
import java.util.Objects;
import java.util.SortedSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.sonar.server.computation.task.projectanalysis.duplication.CrossProjectDuplicate;
import org.sonar.server.computation.task.projectanalysis.duplication.Duplicate;
import org.sonar.server.computation.task.projectanalysis.duplication.InProjectDuplicate;
import org.sonar.server.computation.task.projectanalysis.duplication.InnerDuplicate;
import org.sonar.server.computation.task.projectanalysis.duplication.TextBlock;

@Immutable
public final class Duplication {
    private static final Ordering<Duplicate> DUPLICATE_ORDERING = Ordering.from((Comparator)DuplicateComparatorByType.INSTANCE).compound((Comparator)Ordering.natural().onResultOf((Function)DuplicateToFileKey.INSTANCE)).compound((Comparator)Ordering.natural().onResultOf((Function)DuplicateToTextBlock.INSTANCE));
    private final TextBlock original;
    private final SortedSet<Duplicate> duplicates;

    public Duplication(TextBlock original, Iterable<Duplicate> duplicates) {
        this.original = Objects.requireNonNull(original, "original TextBlock can not be null");
        this.duplicates = FluentIterable.from(Objects.requireNonNull(duplicates, "duplicates can not be null")).filter((Predicate)FailOnNullDuplicate.INSTANCE).filter((Predicate)new EnsureInnerDuplicateIsNotOriginalTextBlock(original)).toSortedSet(DUPLICATE_ORDERING);
        Preconditions.checkArgument((!this.duplicates.isEmpty() ? 1 : 0) != 0, (Object)"duplicates can not be empty");
    }

    public TextBlock getOriginal() {
        return this.original;
    }

    public SortedSet<Duplicate> getDuplicates() {
        return this.duplicates;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Duplication that = (Duplication)o;
        return this.original.equals(that.original) && this.duplicates.equals(that.duplicates);
    }

    public int hashCode() {
        return Objects.hash(this.original, this.duplicates);
    }

    public String toString() {
        return "Duplication{original=" + this.original + ", duplicates=" + this.duplicates + '}';
    }

    private static enum DuplicateToFileKey implements Function<Duplicate, String>
    {
        INSTANCE;


        @Nonnull
        public String apply(@Nonnull Duplicate duplicate) {
            if (duplicate instanceof InnerDuplicate) {
                return "";
            }
            if (duplicate instanceof InProjectDuplicate) {
                return ((InProjectDuplicate)duplicate).getFile().getKey();
            }
            if (duplicate instanceof CrossProjectDuplicate) {
                return ((CrossProjectDuplicate)duplicate).getFileKey();
            }
            throw new IllegalArgumentException("Unsupported type of Duplicate " + duplicate.getClass().getName());
        }
    }

    private static class EnsureInnerDuplicateIsNotOriginalTextBlock
    implements Predicate<Duplicate> {
        private final TextBlock original;

        public EnsureInnerDuplicateIsNotOriginalTextBlock(TextBlock original) {
            this.original = original;
        }

        public boolean apply(@Nullable Duplicate input) {
            if (input instanceof InnerDuplicate) {
                Preconditions.checkArgument((!this.original.equals(input.getTextBlock()) ? 1 : 0) != 0, (Object)"TextBlock of an InnerDuplicate can not be the original TextBlock");
            }
            return true;
        }
    }

    private static enum DuplicateToTextBlock implements Function<Duplicate, TextBlock>
    {
        INSTANCE;


        @Nonnull
        public TextBlock apply(@Nonnull Duplicate input) {
            return input.getTextBlock();
        }
    }

    private static enum DuplicateComparatorByType implements Comparator<Duplicate>
    {
        INSTANCE;


        @Override
        public int compare(Duplicate o1, Duplicate o2) {
            return DuplicateComparatorByType.toIndexType(o1) - DuplicateComparatorByType.toIndexType(o2);
        }

        private static int toIndexType(Duplicate duplicate) {
            if (duplicate instanceof InnerDuplicate) {
                return 0;
            }
            if (duplicate instanceof InProjectDuplicate) {
                return 1;
            }
            if (duplicate instanceof CrossProjectDuplicate) {
                return 2;
            }
            throw new IllegalArgumentException("Unsupported type of Duplicate " + duplicate.getClass().getName());
        }
    }

    private static enum FailOnNullDuplicate implements Predicate<Duplicate>
    {
        INSTANCE;


        public boolean apply(@Nullable Duplicate input) {
            Objects.requireNonNull(input, "duplicates can not contain null");
            return true;
        }
    }
}

