/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.computation.task.projectanalysis.component;

import org.sonar.server.computation.task.projectanalysis.component.Component;
import org.sonar.server.computation.task.projectanalysis.component.ComponentVisitor;
import org.sonar.server.computation.task.projectanalysis.component.CrawlerDepthLimit;
import org.sonar.server.computation.task.projectanalysis.component.DequeBasedPath;
import org.sonar.server.computation.task.projectanalysis.component.PathAwareVisitor;
import org.sonar.server.computation.task.projectanalysis.component.PathElementImpl;
import org.sonar.server.computation.task.projectanalysis.component.VisitorWrapper;

public class PathAwareVisitorWrapper<T>
implements VisitorWrapper {
    private final PathAwareVisitor<T> delegate;
    private final DequeBasedPath<T> stack = new DequeBasedPath();

    public PathAwareVisitorWrapper(PathAwareVisitor<T> delegate) {
        this.delegate = delegate;
    }

    @Override
    public ComponentVisitor getWrappedVisitor() {
        return this.delegate;
    }

    @Override
    public void beforeComponent(Component component) {
        this.stack.add(new PathElementImpl<T>(component, this.createForComponent(component)));
    }

    @Override
    public void afterComponent(Component component) {
        this.stack.pop();
    }

    @Override
    public void visitProject(Component tree) {
        this.delegate.visitProject(tree, this.stack);
    }

    @Override
    public void visitModule(Component tree) {
        this.delegate.visitModule(tree, this.stack);
    }

    @Override
    public void visitDirectory(Component tree) {
        this.delegate.visitDirectory(tree, this.stack);
    }

    @Override
    public void visitFile(Component tree) {
        this.delegate.visitFile(tree, this.stack);
    }

    @Override
    public void visitView(Component view) {
        this.delegate.visitView(view, this.stack);
    }

    @Override
    public void visitSubView(Component subView) {
        this.delegate.visitSubView(subView, this.stack);
    }

    @Override
    public void visitProjectView(Component projectView) {
        this.delegate.visitProjectView(projectView, this.stack);
    }

    @Override
    public void visitAny(Component component) {
        this.delegate.visitAny(component, this.stack);
    }

    @Override
    public ComponentVisitor.Order getOrder() {
        return this.delegate.getOrder();
    }

    @Override
    public CrawlerDepthLimit getMaxDepth() {
        return this.delegate.getMaxDepth();
    }

    private T createForComponent(Component component) {
        switch (component.getType()) {
            case PROJECT: {
                return this.delegate.getFactory().createForProject(component);
            }
            case MODULE: {
                return this.delegate.getFactory().createForModule(component);
            }
            case DIRECTORY: {
                return this.delegate.getFactory().createForDirectory(component);
            }
            case FILE: {
                return this.delegate.getFactory().createForFile(component);
            }
            case VIEW: {
                return this.delegate.getFactory().createForView(component);
            }
            case SUBVIEW: {
                return this.delegate.getFactory().createForSubView(component);
            }
            case PROJECT_VIEW: {
                return this.delegate.getFactory().createForProjectView(component);
            }
        }
        throw new IllegalArgumentException(String.format("Unsupported component type %s, can not create stack object", new Object[]{component.getType()}));
    }

    public String toString() {
        return this.delegate.toString();
    }
}

