/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.computation.task.projectanalysis.component;

import java.util.Objects;
import org.sonar.server.computation.task.projectanalysis.component.Component;
import org.sonar.server.computation.task.projectanalysis.component.ComponentCrawler;
import org.sonar.server.computation.task.projectanalysis.component.ComponentVisitor;
import org.sonar.server.computation.task.projectanalysis.component.CrawlerDepthLimit;
import org.sonar.server.computation.task.projectanalysis.component.TypeAwareVisitor;
import org.sonar.server.computation.task.projectanalysis.component.VisitException;

public final class DepthTraversalTypeAwareCrawler
implements ComponentCrawler {
    private final TypeAwareVisitor visitor;

    public DepthTraversalTypeAwareCrawler(TypeAwareVisitor visitor) {
        this.visitor = Objects.requireNonNull(visitor);
    }

    @Override
    public void visit(Component component) {
        try {
            this.visitImpl(component);
        }
        catch (RuntimeException e) {
            VisitException.rethrowOrWrap(e, "Visit of Component {key=%s,uuid=%s,type=%s} failed", new Object[]{component.getKey(), component.getUuid(), component.getType()});
        }
    }

    private void visitImpl(Component component) {
        if (!this.verifyDepth(component)) {
            return;
        }
        if (this.visitor.getOrder() == ComponentVisitor.Order.PRE_ORDER) {
            this.visitNode(component);
        }
        this.visitChildren(component);
        if (this.visitor.getOrder() == ComponentVisitor.Order.POST_ORDER) {
            this.visitNode(component);
        }
    }

    private boolean verifyDepth(Component component) {
        CrawlerDepthLimit maxDepth = this.visitor.getMaxDepth();
        return maxDepth.isSameAs(component.getType()) || maxDepth.isDeeperThan(component.getType());
    }

    private void visitNode(Component component) {
        this.visitor.visitAny(component);
        switch (component.getType()) {
            case PROJECT: {
                this.visitor.visitProject(component);
                break;
            }
            case MODULE: {
                this.visitor.visitModule(component);
                break;
            }
            case DIRECTORY: {
                this.visitor.visitDirectory(component);
                break;
            }
            case FILE: {
                this.visitor.visitFile(component);
                break;
            }
            case VIEW: {
                this.visitor.visitView(component);
                break;
            }
            case SUBVIEW: {
                this.visitor.visitSubView(component);
                break;
            }
            case PROJECT_VIEW: {
                this.visitor.visitProjectView(component);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported Component type " + (Object)((Object)component.getType()));
            }
        }
    }

    private void visitChildren(Component component) {
        for (Component child : component.getChildren()) {
            if (!this.verifyDepth(child)) continue;
            this.visit(child);
        }
    }
}

