/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.ce.ws;

import com.google.common.base.Preconditions;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.api.utils.DateUtils;
import org.sonar.api.utils.System2;
import org.sonar.core.util.Protobuf;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.ce.CeActivityDto;
import org.sonar.db.ce.CeQueueDto;
import org.sonar.db.ce.CeTaskCharacteristicDto;
import org.sonar.db.component.ComponentDto;
import org.sonar.db.organization.OrganizationDto;
import org.sonar.db.user.UserDto;
import org.sonarqube.ws.Ce;
import org.sonarqube.ws.Common;

public class TaskFormatter {
    private final DbClient dbClient;
    private final System2 system2;

    public TaskFormatter(DbClient dbClient, System2 system2) {
        this.dbClient = dbClient;
        this.system2 = system2;
    }

    public List<Ce.Task> formatQueue(DbSession dbSession, List<CeQueueDto> dtos) {
        DtoCache cache = DtoCache.forQueueDtos(this.dbClient, dbSession, dtos);
        return (List)dtos.stream().map(input -> this.formatQueue((CeQueueDto)input, cache)).collect(MoreCollectors.toList((int)dtos.size()));
    }

    public Ce.Task formatQueue(DbSession dbSession, CeQueueDto queue) {
        return this.formatQueue(queue, DtoCache.forQueueDtos(this.dbClient, dbSession, Collections.singletonList(queue)));
    }

    private Ce.Task formatQueue(CeQueueDto dto, DtoCache cache) {
        Ce.Task.Builder builder = Ce.Task.newBuilder();
        String organizationKey = cache.getOrganizationKey(dto.getComponentUuid());
        Protobuf.setNullable((Object)organizationKey, arg_0 -> ((Ce.Task.Builder)builder).setOrganization(arg_0));
        if (dto.getComponentUuid() != null) {
            builder.setComponentId(dto.getComponentUuid());
            TaskFormatter.setComponent(builder, dto.getComponentUuid(), cache);
        }
        builder.setId(dto.getUuid());
        builder.setStatus(Ce.TaskStatus.valueOf((String)dto.getStatus().name()));
        builder.setType(dto.getTaskType());
        builder.setLogs(false);
        cache.getUser(dto.getSubmitterUuid()).ifPresent(user -> builder.setSubmitterLogin(user.getLogin()));
        builder.setSubmittedAt(DateUtils.formatDateTime((Date)new Date(dto.getCreatedAt())));
        Protobuf.setNullable((Object)dto.getStartedAt(), arg_0 -> ((Ce.Task.Builder)builder).setStartedAt(arg_0), DateUtils::formatDateTime);
        Protobuf.setNullable((Object)this.computeExecutionTimeMs(dto), arg_0 -> ((Ce.Task.Builder)builder).setExecutionTimeMs(arg_0));
        TaskFormatter.setBranchOrPullRequest(builder, dto.getUuid(), cache);
        return builder.build();
    }

    public Ce.Task formatActivity(DbSession dbSession, CeActivityDto dto, @Nullable String scannerContext) {
        return TaskFormatter.formatActivity(dto, DtoCache.forActivityDtos(this.dbClient, dbSession, Collections.singletonList(dto)), scannerContext);
    }

    public List<Ce.Task> formatActivity(DbSession dbSession, List<CeActivityDto> dtos) {
        DtoCache cache = DtoCache.forActivityDtos(this.dbClient, dbSession, dtos);
        return (List)dtos.stream().map(input -> TaskFormatter.formatActivity(input, cache, null)).collect(MoreCollectors.toList((int)dtos.size()));
    }

    private static Ce.Task formatActivity(CeActivityDto dto, DtoCache cache, @Nullable String scannerContext) {
        Ce.Task.Builder builder = Ce.Task.newBuilder();
        String organizationKey = cache.getOrganizationKey(dto.getComponentUuid());
        Protobuf.setNullable((Object)organizationKey, arg_0 -> ((Ce.Task.Builder)builder).setOrganization(arg_0));
        builder.setId(dto.getUuid());
        builder.setStatus(Ce.TaskStatus.valueOf((String)dto.getStatus().name()));
        builder.setType(dto.getTaskType());
        builder.setLogs(false);
        Protobuf.setNullable((Object)dto.getComponentUuid(), uuid -> TaskFormatter.setComponent(builder, uuid, cache).setComponentId(uuid));
        String analysisUuid = dto.getAnalysisUuid();
        Protobuf.setNullable((Object)analysisUuid, arg_0 -> ((Ce.Task.Builder)builder).setAnalysisId(arg_0));
        TaskFormatter.setBranchOrPullRequest(builder, dto.getUuid(), cache);
        Protobuf.setNullable((Object)analysisUuid, arg_0 -> ((Ce.Task.Builder)builder).setAnalysisId(arg_0));
        cache.getUser(dto.getSubmitterUuid()).ifPresent(user -> builder.setSubmitterLogin(user.getLogin()));
        builder.setSubmittedAt(DateUtils.formatDateTime((Date)new Date(dto.getSubmittedAt())));
        Protobuf.setNullable((Object)dto.getStartedAt(), arg_0 -> ((Ce.Task.Builder)builder).setStartedAt(arg_0), DateUtils::formatDateTime);
        Protobuf.setNullable((Object)dto.getExecutedAt(), arg_0 -> ((Ce.Task.Builder)builder).setExecutedAt(arg_0), DateUtils::formatDateTime);
        Protobuf.setNullable((Object)dto.getExecutionTimeMs(), arg_0 -> ((Ce.Task.Builder)builder).setExecutionTimeMs(arg_0));
        Protobuf.setNullable((Object)dto.getErrorMessage(), arg_0 -> ((Ce.Task.Builder)builder).setErrorMessage(arg_0));
        Protobuf.setNullable((Object)dto.getErrorStacktrace(), arg_0 -> ((Ce.Task.Builder)builder).setErrorStacktrace(arg_0));
        Protobuf.setNullable((Object)dto.getErrorType(), arg_0 -> ((Ce.Task.Builder)builder).setErrorType(arg_0));
        Protobuf.setNullable((Object)scannerContext, arg_0 -> ((Ce.Task.Builder)builder).setScannerContext(arg_0));
        builder.setHasScannerContext(dto.isHasScannerContext());
        return builder.build();
    }

    private static Ce.Task.Builder setComponent(Ce.Task.Builder builder, @Nullable String componentUuid, DtoCache componentDtoCache) {
        ComponentDto componentDto = componentDtoCache.getComponent(componentUuid);
        if (componentDto == null) {
            return builder;
        }
        builder.setComponentKey(componentDto.getKey());
        builder.setComponentName(componentDto.name());
        builder.setComponentQualifier(componentDto.qualifier());
        return builder;
    }

    private static Ce.Task.Builder setBranchOrPullRequest(Ce.Task.Builder builder, String taskUuid, DtoCache componentDtoCache) {
        componentDtoCache.getBranchKey(taskUuid).ifPresent(b -> {
            Common.BranchType branchType = componentDtoCache.getBranchType(taskUuid).orElseThrow(() -> new IllegalStateException(String.format("Could not find branch type of task '%s'", taskUuid)));
            switch (branchType) {
                case LONG: 
                case SHORT: {
                    builder.setBranchType(branchType);
                    builder.setBranch(b);
                    break;
                }
                default: {
                    throw new IllegalStateException(String.format("Unknown branch type '%s'", branchType));
                }
            }
        });
        componentDtoCache.getPullRequest(taskUuid).ifPresent(arg_0 -> ((Ce.Task.Builder)builder).setPullRequest(arg_0));
        return builder;
    }

    @CheckForNull
    private Long computeExecutionTimeMs(CeQueueDto dto) {
        Long startedAt = dto.getStartedAt();
        if (startedAt == null) {
            return null;
        }
        return this.system2.now() - startedAt;
    }

    private static class DtoCache {
        private final Map<String, ComponentDto> componentsByUuid;
        private final Map<String, OrganizationDto> organizationsByUuid;
        private final Multimap<String, CeTaskCharacteristicDto> characteristicsByTaskUuid;
        private final Map<String, UserDto> usersByUuid;

        private DtoCache(Map<String, ComponentDto> componentsByUuid, Map<String, OrganizationDto> organizationsByUuid, Multimap<String, CeTaskCharacteristicDto> characteristicsByTaskUuid, Map<String, UserDto> usersByUuid) {
            this.componentsByUuid = componentsByUuid;
            this.organizationsByUuid = organizationsByUuid;
            this.characteristicsByTaskUuid = characteristicsByTaskUuid;
            this.usersByUuid = usersByUuid;
        }

        static DtoCache forQueueDtos(DbClient dbClient, DbSession dbSession, Collection<CeQueueDto> ceQueueDtos) {
            Map componentsByUuid = (Map)dbClient.componentDao().selectByUuids(dbSession, DtoCache.componentUuidsOfCeQueues(ceQueueDtos)).stream().collect(MoreCollectors.uniqueIndex(ComponentDto::uuid));
            Multimap characteristicsByTaskUuid = (Multimap)dbClient.ceTaskCharacteristicsDao().selectByTaskUuids(dbSession, ceQueueDtos.stream().map(CeQueueDto::getUuid).collect(Collectors.toList())).stream().collect(MoreCollectors.index(CeTaskCharacteristicDto::getTaskUuid));
            Set submitterUuids = (Set)ceQueueDtos.stream().map(CeQueueDto::getSubmitterUuid).filter(Objects::nonNull).collect(MoreCollectors.toSet());
            Map usersByUuid = (Map)dbClient.userDao().selectByUuids(dbSession, (Collection)submitterUuids).stream().collect(MoreCollectors.uniqueIndex(UserDto::getUuid));
            return new DtoCache(componentsByUuid, DtoCache.buildOrganizationsByUuid(dbClient, dbSession, componentsByUuid), (Multimap<String, CeTaskCharacteristicDto>)characteristicsByTaskUuid, usersByUuid);
        }

        private static Set<String> componentUuidsOfCeQueues(Collection<CeQueueDto> ceQueueDtos) {
            return (Set)ceQueueDtos.stream().filter(Objects::nonNull).map(CeQueueDto::getComponentUuid).filter(Objects::nonNull).collect(MoreCollectors.toSet((int)ceQueueDtos.size()));
        }

        static DtoCache forActivityDtos(DbClient dbClient, DbSession dbSession, Collection<CeActivityDto> ceActivityDtos) {
            Map componentsByUuid = (Map)dbClient.componentDao().selectByUuids(dbSession, DtoCache.getComponentUuidsOfCeActivities(ceActivityDtos)).stream().collect(MoreCollectors.uniqueIndex(ComponentDto::uuid));
            Multimap characteristicsByTaskUuid = (Multimap)dbClient.ceTaskCharacteristicsDao().selectByTaskUuids(dbSession, ceActivityDtos.stream().map(CeActivityDto::getUuid).collect(Collectors.toList())).stream().collect(MoreCollectors.index(CeTaskCharacteristicDto::getTaskUuid));
            Set submitterUuids = (Set)ceActivityDtos.stream().map(CeActivityDto::getSubmitterUuid).filter(Objects::nonNull).collect(MoreCollectors.toSet());
            Map usersByUuid = (Map)dbClient.userDao().selectByUuids(dbSession, (Collection)submitterUuids).stream().collect(MoreCollectors.uniqueIndex(UserDto::getUuid));
            return new DtoCache(componentsByUuid, DtoCache.buildOrganizationsByUuid(dbClient, dbSession, componentsByUuid), (Multimap<String, CeTaskCharacteristicDto>)characteristicsByTaskUuid, usersByUuid);
        }

        private static Set<String> getComponentUuidsOfCeActivities(Collection<CeActivityDto> ceActivityDtos) {
            return (Set)ceActivityDtos.stream().filter(Objects::nonNull).map(CeActivityDto::getComponentUuid).filter(Objects::nonNull).collect(MoreCollectors.toSet((int)ceActivityDtos.size()));
        }

        private static Map<String, OrganizationDto> buildOrganizationsByUuid(DbClient dbClient, DbSession dbSession, Map<String, ComponentDto> componentsByUuid) {
            return (Map)dbClient.organizationDao().selectByUuids(dbSession, (Set)componentsByUuid.values().stream().map(ComponentDto::getOrganizationUuid).collect(MoreCollectors.toSet((int)componentsByUuid.size()))).stream().collect(MoreCollectors.uniqueIndex(OrganizationDto::getUuid));
        }

        @CheckForNull
        ComponentDto getComponent(@Nullable String uuid) {
            if (uuid == null) {
                return null;
            }
            return this.componentsByUuid.get(uuid);
        }

        @CheckForNull
        String getOrganizationKey(@Nullable String componentUuid) {
            if (componentUuid == null) {
                return null;
            }
            ComponentDto componentDto = this.componentsByUuid.get(componentUuid);
            if (componentDto == null) {
                return null;
            }
            String organizationUuid = componentDto.getOrganizationUuid();
            OrganizationDto organizationDto = this.organizationsByUuid.get(organizationUuid);
            Preconditions.checkState((organizationDto != null ? 1 : 0) != 0, (String)"Organization with uuid '%s' not found", (Object[])new Object[]{organizationUuid});
            return organizationDto.getKey();
        }

        Optional<String> getBranchKey(String taskUuid) {
            return this.characteristicsByTaskUuid.get((Object)taskUuid).stream().filter(c -> c.getKey().equals("branch")).map(CeTaskCharacteristicDto::getValue).findAny();
        }

        Optional<Common.BranchType> getBranchType(String taskUuid) {
            return this.characteristicsByTaskUuid.get((Object)taskUuid).stream().filter(c -> c.getKey().equals("branchType")).map(c -> Common.BranchType.valueOf((String)c.getValue())).findAny();
        }

        Optional<String> getPullRequest(String taskUuid) {
            return this.characteristicsByTaskUuid.get((Object)taskUuid).stream().filter(c -> c.getKey().equals("pullRequest")).map(CeTaskCharacteristicDto::getValue).findAny();
        }

        Optional<UserDto> getUser(@Nullable String userUuid) {
            if (userUuid == null) {
                return Optional.empty();
            }
            return Optional.ofNullable(this.usersByUuid.get(userUuid));
        }
    }
}

