/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.branch.ws;

import com.google.common.base.Preconditions;
import java.util.Optional;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.component.ComponentDto;
import org.sonar.server.branch.ws.BranchWsAction;
import org.sonar.server.branch.ws.BranchesWs;
import org.sonar.server.component.ComponentFinder;
import org.sonar.server.user.UserSession;

public class RenameAction
implements BranchWsAction {
    private final ComponentFinder componentFinder;
    private final UserSession userSession;
    private final DbClient dbClient;

    public RenameAction(DbClient dbClient, ComponentFinder componentFinder, UserSession userSession) {
        this.dbClient = dbClient;
        this.componentFinder = componentFinder;
        this.userSession = userSession;
    }

    public void define(WebService.NewController context) {
        WebService.NewAction action = context.createAction("rename").setSince("6.6").setDescription("Rename the main branch of a project.<br/>Requires 'Administer' permission on the specified project.").setPost(true).setHandler((RequestHandler)this);
        BranchesWs.addProjectParam(action);
        action.createParam("name").setRequired(true).setMaximumLength(Integer.valueOf(255)).setDescription("New name of the main branch").setExampleValue((Object)"branch1");
    }

    public void handle(Request request, Response response) throws Exception {
        this.userSession.checkLoggedIn();
        String projectKey = request.mandatoryParam("project");
        String newBranchName = request.mandatoryParam("name");
        try (DbSession dbSession = this.dbClient.openSession(false);){
            ComponentDto project = this.componentFinder.getRootComponentByUuidOrKey(dbSession, null, projectKey);
            this.checkPermission(project);
            Optional existingBranch = this.dbClient.branchDao().selectByBranchKey(dbSession, project.uuid(), newBranchName);
            Preconditions.checkArgument((!existingBranch.filter(b -> !b.isMain()).isPresent() ? 1 : 0) != 0, (String)"Impossible to update branch name: a branch with name \"%s\" already exists in the project.", (Object[])new Object[]{newBranchName});
            this.dbClient.branchDao().updateMainBranchName(dbSession, project.uuid(), newBranchName);
            dbSession.commit();
            response.noContent();
        }
    }

    private void checkPermission(ComponentDto project) {
        this.userSession.checkComponentPermission("admin", project);
    }
}

