/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.batch;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.HiddenFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.lang.StringUtils;
import org.picocontainer.Startable;
import org.sonar.api.server.ServerSide;
import org.sonar.server.exceptions.NotFoundException;
import org.sonar.server.platform.ServerFileSystem;

@ServerSide
public class BatchIndex
implements Startable {
    private final ServerFileSystem fs;
    private String index;
    private File batchDir;

    public BatchIndex(ServerFileSystem fs) {
        this.fs = fs;
    }

    public void start() {
        StringBuilder sb = new StringBuilder();
        this.batchDir = new File(this.fs.getHomeDir(), "lib/scanner");
        if (this.batchDir.exists()) {
            Collection files = FileUtils.listFiles((File)this.batchDir, (IOFileFilter)HiddenFileFilter.VISIBLE, (IOFileFilter)FileFilterUtils.directoryFileFilter());
            for (File file : files) {
                String filename = file.getName();
                if (!StringUtils.endsWith((String)filename, (String)".jar")) continue;
                try {
                    FileInputStream fis = new FileInputStream(file);
                    Throwable throwable = null;
                    try {
                        sb.append(filename).append('|').append(DigestUtils.md5Hex((InputStream)fis)).append('\n');
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (fis == null) continue;
                        if (throwable != null) {
                            try {
                                fis.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        fis.close();
                    }
                }
                catch (IOException e) {
                    throw new IllegalStateException("Fail to compute hash", e);
                }
            }
        }
        this.index = sb.toString();
    }

    public void stop() {
    }

    String getIndex() {
        return this.index;
    }

    File getFile(String filename) {
        try {
            File input = new File(this.batchDir, filename);
            if (!input.exists() || !FileUtils.directoryContains((File)this.batchDir, (File)input)) {
                throw new NotFoundException("Bad filename: " + filename);
            }
            return input;
        }
        catch (IOException e) {
            throw new IllegalStateException("Can get file " + filename, e);
        }
    }
}

