/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.badge.ws;

import java.util.Optional;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.WebService;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.component.BranchDto;
import org.sonar.db.component.BranchType;
import org.sonar.db.component.ComponentDto;
import org.sonar.server.badge.ws.ProjectBadgesException;
import org.sonar.server.component.ComponentFinder;
import org.sonar.server.exceptions.NotFoundException;
import org.sonar.server.user.UserSession;

public class ProjectBadgesSupport {
    private static final String PARAM_PROJECT = "project";
    private static final String PARAM_BRANCH = "branch";
    private final UserSession userSession;
    private final DbClient dbClient;
    private final ComponentFinder componentFinder;

    public ProjectBadgesSupport(UserSession userSession, DbClient dbClient, ComponentFinder componentFinder) {
        this.userSession = userSession;
        this.dbClient = dbClient;
        this.componentFinder = componentFinder;
    }

    void addProjectAndBranchParams(WebService.NewAction action) {
        action.createParam(PARAM_PROJECT).setDescription("Project or application key").setRequired(true).setExampleValue((Object)"my_project");
        action.createParam(PARAM_BRANCH).setDescription("Long living branch key").setExampleValue((Object)"feature/my_branch");
    }

    ComponentDto getComponent(DbSession dbSession, Request request) {
        try {
            String projectKey = request.mandatoryParam(PARAM_PROJECT);
            String branchName = request.param(PARAM_BRANCH);
            ComponentDto project = this.componentFinder.getByKeyAndOptionalBranchOrPullRequest(dbSession, projectKey, branchName, null);
            this.checkComponentType(dbSession, project);
            this.userSession.checkComponentPermission("user", project);
            return project;
        }
        catch (NotFoundException e) {
            throw new NotFoundException("Project has not been found");
        }
    }

    private void checkComponentType(DbSession dbSession, ComponentDto project) {
        Optional branch = this.dbClient.branchDao().selectByUuid(dbSession, project.uuid());
        if (project.isPrivate()) {
            throw ProjectBadgesSupport.generateInvalidProjectExcpetion();
        }
        if (branch.isPresent() && !((BranchDto)branch.get()).getBranchType().equals((Object)BranchType.LONG)) {
            throw ProjectBadgesSupport.generateInvalidProjectExcpetion();
        }
        if (!project.qualifier().equals("TRK") && !project.qualifier().equals("APP")) {
            throw ProjectBadgesSupport.generateInvalidProjectExcpetion();
        }
    }

    private static ProjectBadgesException generateInvalidProjectExcpetion() {
        return new ProjectBadgesException("Project is invalid");
    }
}

