/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.authentication.ws;

import javax.annotation.Nullable;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.server.ws.WebService;
import org.sonar.api.web.ServletFilter;
import org.sonar.db.user.UserDto;
import org.sonar.server.authentication.CredentialsAuthenticator;
import org.sonar.server.authentication.JwtHttpHandler;
import org.sonar.server.authentication.event.AuthenticationEvent;
import org.sonar.server.authentication.event.AuthenticationException;
import org.sonar.server.authentication.ws.AuthenticationWsAction;
import org.sonar.server.exceptions.UnauthorizedException;
import org.sonar.server.user.ThreadLocalUserSession;
import org.sonar.server.user.UserSessionFactory;
import org.sonar.server.ws.ServletFilterHandler;
import org.sonarqube.ws.client.WsRequest;

public class LoginAction
extends ServletFilter
implements AuthenticationWsAction {
    private static final String LOGIN_ACTION = "login";
    public static final String LOGIN_URL = "/api/authentication/login";
    private final CredentialsAuthenticator credentialsAuthenticator;
    private final JwtHttpHandler jwtHttpHandler;
    private final ThreadLocalUserSession threadLocalUserSession;
    private final AuthenticationEvent authenticationEvent;
    private final UserSessionFactory userSessionFactory;

    public LoginAction(CredentialsAuthenticator credentialsAuthenticator, JwtHttpHandler jwtHttpHandler, ThreadLocalUserSession threadLocalUserSession, AuthenticationEvent authenticationEvent, UserSessionFactory userSessionFactory) {
        this.credentialsAuthenticator = credentialsAuthenticator;
        this.jwtHttpHandler = jwtHttpHandler;
        this.threadLocalUserSession = threadLocalUserSession;
        this.authenticationEvent = authenticationEvent;
        this.userSessionFactory = userSessionFactory;
    }

    @Override
    public void define(WebService.NewController controller) {
        WebService.NewAction action = controller.createAction(LOGIN_ACTION).setDescription("Authenticate a user.").setSince("6.0").setPost(true).setHandler(ServletFilterHandler.INSTANCE);
        action.createParam(LOGIN_ACTION).setDescription("Login of the user").setRequired(true);
        action.createParam("password").setDescription("Password of the user").setRequired(true);
    }

    public ServletFilter.UrlPattern doGetPattern() {
        return ServletFilter.UrlPattern.create((String)LOGIN_URL);
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain chain) {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        if (!request.getMethod().equals(WsRequest.Method.POST.name())) {
            response.setStatus(400);
            return;
        }
        String login = request.getParameter(LOGIN_ACTION);
        String password = request.getParameter("password");
        try {
            UserDto userDto = this.authenticate(request, login, password);
            this.jwtHttpHandler.generateToken(userDto, request, response);
            this.threadLocalUserSession.set(this.userSessionFactory.create(userDto));
        }
        catch (AuthenticationException e) {
            this.authenticationEvent.loginFailure(request, e);
            response.setStatus(401);
        }
        catch (UnauthorizedException e) {
            response.setStatus(e.httpCode());
        }
    }

    private UserDto authenticate(HttpServletRequest request, @Nullable String login, @Nullable String password) {
        if (StringUtils.isEmpty((String)login) || StringUtils.isEmpty((String)password)) {
            throw AuthenticationException.newBuilder().setSource(AuthenticationEvent.Source.local(AuthenticationEvent.Method.FORM)).setLogin(login).setMessage("Empty login and/or password").build();
        }
        return this.credentialsAuthenticator.authenticate(login, password, request, AuthenticationEvent.Method.FORM);
    }

    public void init(FilterConfig filterConfig) {
    }

    public void destroy() {
    }
}

