/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.authentication.exception;

import org.sonar.api.server.authentication.IdentityProvider;
import org.sonar.api.server.authentication.UserIdentity;
import org.sonar.db.user.UserDto;
import org.sonar.server.authentication.AuthenticationRedirection;
import org.sonar.server.authentication.exception.RedirectionException;

public class EmailAlreadyExistsRedirectionException
extends RedirectionException {
    private static final String PATH = "/sessions/email_already_exists?email=%s&login=%s&provider=%s&existingLogin=%s&existingProvider=%s";
    private final String email;
    private final UserDto existingUser;
    private final UserIdentity userIdentity;
    private final IdentityProvider provider;

    public EmailAlreadyExistsRedirectionException(String email, UserDto existingUser, UserIdentity userIdentity, IdentityProvider provider) {
        this.email = email;
        this.existingUser = existingUser;
        this.userIdentity = userIdentity;
        this.provider = provider;
    }

    @Override
    public String getPath(String contextPath) {
        return contextPath + String.format(PATH, AuthenticationRedirection.encodeMessage(this.email), AuthenticationRedirection.encodeMessage(this.userIdentity.getProviderLogin()), AuthenticationRedirection.encodeMessage(this.provider.getKey()), AuthenticationRedirection.encodeMessage(this.existingUser.getExternalLogin()), AuthenticationRedirection.encodeMessage(this.existingUser.getExternalIdentityProvider()));
    }
}

