/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.authentication;

import org.apache.commons.lang.StringUtils;
import org.sonar.api.Startable;
import org.sonar.api.platform.Server;
import org.sonar.api.server.authentication.OAuth2IdentityProvider;
import org.sonar.api.utils.log.Loggers;

public class LogOAuthWarning
implements Startable {
    private final Server server;
    private final OAuth2IdentityProvider[] providers;

    public LogOAuthWarning(Server server, OAuth2IdentityProvider[] providers) {
        this.server = server;
        this.providers = providers;
    }

    public LogOAuthWarning(Server server) {
        this(server, new OAuth2IdentityProvider[0]);
    }

    public void start() {
        if (this.providers.length == 0) {
            return;
        }
        String publicRootUrl = this.server.getPublicRootUrl();
        if (StringUtils.startsWithIgnoreCase((String)publicRootUrl, (String)"http:")) {
            Loggers.get(this.getClass()).warn("For security reasons, OAuth authentication should use HTTPS. You should set the property 'Administration > Configuration > Server base URL' to a HTTPS URL.");
        }
    }

    public void stop() {
    }
}

