/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.app;

import ch.qos.logback.access.PatternLayoutEncoder;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.FileAppender;
import ch.qos.logback.core.encoder.Encoder;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Valve;
import org.apache.catalina.startup.Tomcat;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.process.Props;
import org.sonar.process.logging.LogbackHelper;
import org.sonar.server.app.ProgrammaticLogbackValve;

class TomcatAccessLog {
    private static final String PROPERTY_ENABLE = "sonar.web.accessLogs.enable";
    private static final String PROPERTY_PATTERN = "sonar.web.accessLogs.pattern";
    private static final String DEFAULT_SQ_ACCESS_LOG_PATTERN = "%h %l %u [%t] \"%r\" %s %b \"%i{Referer}\" \"%i{User-Agent}\" \"%reqAttribute{ID}\"";

    TomcatAccessLog() {
    }

    void configure(Tomcat tomcat, Props props) {
        tomcat.setSilent(true);
        tomcat.getService().addLifecycleListener((LifecycleListener)new LifecycleLogger(Loggers.get(TomcatAccessLog.class)));
        TomcatAccessLog.configureLogbackAccess(tomcat, props);
    }

    private static void configureLogbackAccess(Tomcat tomcat, Props props) {
        if (props.valueAsBoolean(PROPERTY_ENABLE, true)) {
            ProgrammaticLogbackValve valve = new ProgrammaticLogbackValve();
            LogbackHelper helper = new LogbackHelper();
            LogbackHelper.RollingPolicy policy = helper.createRollingPolicy((Context)valve, props, "access");
            FileAppender appender = policy.createAppender("ACCESS_LOG");
            PatternLayoutEncoder fileEncoder = new PatternLayoutEncoder();
            fileEncoder.setContext((Context)valve);
            fileEncoder.setPattern(props.value(PROPERTY_PATTERN, DEFAULT_SQ_ACCESS_LOG_PATTERN));
            fileEncoder.start();
            appender.setEncoder((Encoder)fileEncoder);
            appender.start();
            valve.addAppender((Appender)appender);
            tomcat.getHost().getPipeline().addValve((Valve)valve);
        }
    }

    static class LifecycleLogger
    implements LifecycleListener {
        private Logger logger;

        LifecycleLogger(Logger logger) {
            this.logger = logger;
        }

        public void lifecycleEvent(LifecycleEvent event) {
            if ("after_start".equals(event.getType())) {
                this.logger.debug("Tomcat is started");
            } else if ("after_destroy".equals(event.getType())) {
                this.logger.debug("Tomcat is stopped");
            }
        }
    }
}

