/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ce.queue;

import com.google.common.base.MoreObjects;
import com.google.common.base.Strings;
import java.util.Objects;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public class CeTask {
    private final String organizationUuid;
    private final String type;
    private final String uuid;
    private final String componentUuid;
    private final String componentKey;
    private final String componentName;
    private final String submitterUuid;

    private CeTask(Builder builder) {
        this.organizationUuid = Objects.requireNonNull(Strings.emptyToNull((String)builder.organizationUuid), "organizationUuid can't be null nor empty");
        this.uuid = Objects.requireNonNull(Strings.emptyToNull((String)builder.uuid), "uuid can't be null nor empty");
        this.type = Objects.requireNonNull(Strings.emptyToNull((String)builder.type), "type can't be null nor empty");
        this.componentUuid = Strings.emptyToNull((String)builder.componentUuid);
        this.componentKey = Strings.emptyToNull((String)builder.componentKey);
        this.componentName = Strings.emptyToNull((String)builder.componentName);
        this.submitterUuid = Strings.emptyToNull((String)builder.submitterUuid);
    }

    public String getOrganizationUuid() {
        return this.organizationUuid;
    }

    public String getUuid() {
        return this.uuid;
    }

    public String getType() {
        return this.type;
    }

    @CheckForNull
    public String getComponentUuid() {
        return this.componentUuid;
    }

    @CheckForNull
    public String getComponentKey() {
        return this.componentKey;
    }

    @CheckForNull
    public String getComponentName() {
        return this.componentName;
    }

    @CheckForNull
    public String getSubmitterUuid() {
        return this.submitterUuid;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("organizationUuid", (Object)this.organizationUuid).add("type", (Object)this.type).add("uuid", (Object)this.uuid).add("componentUuid", (Object)this.componentUuid).add("componentKey", (Object)this.componentKey).add("componentName", (Object)this.componentName).add("submitterUuid", (Object)this.submitterUuid).toString();
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CeTask ceTask = (CeTask)o;
        return this.uuid.equals(ceTask.uuid);
    }

    public int hashCode() {
        return this.uuid.hashCode();
    }

    public static final class Builder {
        private String organizationUuid;
        private String uuid;
        private String type;
        private String componentUuid;
        private String componentKey;
        private String componentName;
        private String submitterUuid;

        public Builder setOrganizationUuid(String organizationUuid) {
            this.organizationUuid = organizationUuid;
            return this;
        }

        public boolean hasOrganizationUuid() {
            return this.organizationUuid != null;
        }

        public Builder setUuid(String uuid) {
            this.uuid = uuid;
            return this;
        }

        public Builder setType(String type) {
            this.type = type;
            return this;
        }

        public Builder setComponentUuid(String componentUuid) {
            this.componentUuid = componentUuid;
            return this;
        }

        public Builder setComponentKey(@Nullable String s) {
            this.componentKey = s;
            return this;
        }

        public Builder setComponentName(@Nullable String s) {
            this.componentName = s;
            return this;
        }

        public Builder setSubmitterUuid(@Nullable String s) {
            this.submitterUuid = s;
            return this;
        }

        public CeTask build() {
            return new CeTask(this);
        }
    }
}

