/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.tests;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.tree.AnnotationTree;
import org.sonar.plugins.java.api.tree.Arguments;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S5973")
public class TestsStabilityCheck
extends IssuableSubscriptionVisitor {
    private static final String ANNOTATION = "org.testng.annotations.Test";
    private static final String SUCCESS_PERCENTAGE_NAME = "successPercentage";

    @Override
    public List<Tree.Kind> nodesToVisit() {
        return Arrays.asList(Tree.Kind.METHOD, Tree.Kind.CONSTRUCTOR);
    }

    @Override
    public void visitNode(Tree tree) {
        MethodTree methodTree = (MethodTree)tree;
        List<AnnotationTree> annotations = methodTree.modifiers().annotations();
        Optional<Arguments> arguments = annotations.stream().filter(annotationTree -> annotationTree.symbolType().is(ANNOTATION)).map(AnnotationTree::arguments).findFirst();
        if (arguments.isPresent()) {
            for (ExpressionTree argument : arguments.get()) {
                AssignmentExpressionTree assignmentTree;
                IdentifierTree nameTree;
                if (!argument.is(Tree.Kind.ASSIGNMENT) || !(nameTree = (IdentifierTree)(assignmentTree = (AssignmentExpressionTree)argument).variable()).name().equals(SUCCESS_PERCENTAGE_NAME)) continue;
                this.reportIssue(argument, "Make this test stable and remove this \"successPercentage\" argument.");
            }
        }
    }
}

