/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.spring;

import java.util.Collections;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.checks.helpers.SpringUtils;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.SymbolMetadata;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S3750")
public class SpringComponentWithWrongScopeCheck
extends IssuableSubscriptionVisitor {
    @Override
    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.CLASS);
    }

    @Override
    public void visitNode(Tree tree) {
        ClassTree clazzTree = (ClassTree)tree;
        SymbolMetadata clazzMeta = clazzTree.symbol().metadata();
        if (SpringComponentWithWrongScopeCheck.isSpringComponent(clazzMeta) && clazzMeta.isAnnotatedWith("org.springframework.context.annotation.Scope") && !SpringUtils.isScopeSingleton(clazzMeta)) {
            this.checkScopeAnnotation(clazzTree);
        }
    }

    private static boolean isSpringComponent(SymbolMetadata clazzMeta) {
        return clazzMeta.isAnnotatedWith("org.springframework.stereotype.Controller") || clazzMeta.isAnnotatedWith("org.springframework.stereotype.Service") || clazzMeta.isAnnotatedWith("org.springframework.stereotype.Repository");
    }

    private void checkScopeAnnotation(ClassTree tree) {
        tree.modifiers().annotations().stream().filter(a -> a.annotationType().symbolType().fullyQualifiedName().equals("org.springframework.context.annotation.Scope")).forEach(a -> this.reportIssue((Tree)a, "Remove this \"@Scope\" annotation."));
    }
}

