/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.serialization;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.java.checks.helpers.ExpressionsHelper;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.InstanceOfTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S2118")
public class NonSerializableWriteCheck
extends IssuableSubscriptionVisitor {
    private static final MethodMatchers WRITE_OBJECT_MATCHER = MethodMatchers.create().ofTypes("java.io.ObjectOutputStream").names("writeObject").addParametersMatcher("java.lang.Object").build();
    private final Set<Symbol> testedSymbols = new HashSet<Symbol>();

    @Override
    public List<Tree.Kind> nodesToVisit() {
        return Arrays.asList(Tree.Kind.METHOD_INVOCATION, Tree.Kind.INSTANCE_OF);
    }

    @Override
    public void setContext(JavaFileScannerContext context) {
        this.testedSymbols.clear();
        super.setContext(context);
    }

    @Override
    public void visitNode(Tree tree) {
        if (tree.is(Tree.Kind.METHOD_INVOCATION)) {
            this.visitMethodInvocation((MethodInvocationTree)tree);
        } else {
            this.visitInstanceOf((InstanceOfTree)tree);
        }
    }

    private void visitInstanceOf(InstanceOfTree instanceOfTree) {
        ExpressionTree expression = instanceOfTree.expression();
        if (expression.is(Tree.Kind.IDENTIFIER) && instanceOfTree.type().symbolType().is("java.io.Serializable")) {
            this.testedSymbols.add(((IdentifierTree)expression).symbol());
        }
    }

    private boolean isTestedSymbol(ExpressionTree tree) {
        if (tree.is(Tree.Kind.IDENTIFIER)) {
            Symbol symbol = ((IdentifierTree)tree).symbol();
            return this.testedSymbols.contains(symbol);
        }
        return false;
    }

    private void visitMethodInvocation(MethodInvocationTree methodInvocation) {
        ExpressionTree argument;
        if (WRITE_OBJECT_MATCHER.matches(methodInvocation) && !this.isTestedSymbol(argument = (ExpressionTree)methodInvocation.arguments().get(0)) && ExpressionsHelper.isNotSerializable(argument)) {
            this.reportIssue(argument, "Make the \"" + argument.symbolType().fullyQualifiedName() + "\" class \"Serializable\" or don't write it.");
        }
    }
}

