/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.regex;

import org.sonar.check.Rule;
import org.sonar.java.checks.regex.AbstractRegexCheck;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.tree.AnnotationTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonarsource.analyzer.commons.regex.RegexParseResult;
import org.sonarsource.analyzer.commons.regex.ast.RegexTree;
import org.sonarsource.analyzer.commons.regex.ast.SequenceTree;

@Rule(key="S5361")
public class StringReplaceCheck
extends AbstractRegexCheck {
    private static final String LANG_STRING = "java.lang.String";

    @Override
    protected MethodMatchers getMethodInvocationMatchers() {
        return MethodMatchers.create().ofTypes(LANG_STRING).names("replaceAll").addParametersMatcher(LANG_STRING, LANG_STRING).build();
    }

    @Override
    protected boolean filterAnnotation(AnnotationTree annotation) {
        return false;
    }

    @Override
    public void checkRegex(RegexParseResult regexForLiterals, ExpressionTree methodInvocationOrAnnotation) {
        RegexTree regex = regexForLiterals.getResult();
        if (!regexForLiterals.hasSyntaxErrors() && StringReplaceCheck.isPlainString(regex)) {
            this.reportIssue(ExpressionUtils.methodName((MethodInvocationTree)methodInvocationOrAnnotation), "Replace this call to \"replaceAll()\" by a call to the \"replace()\" method.");
        }
    }

    private static boolean isPlainString(RegexTree regex) {
        return regex.is(RegexTree.Kind.CHARACTER) || regex.is(RegexTree.Kind.SEQUENCE) && ((SequenceTree)regex).getItems().stream().allMatch(item -> item.is(RegexTree.Kind.CHARACTER));
    }
}

