/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.regex;

import java.util.List;
import org.sonar.java.checks.regex.AbstractRegexCheckTrackingMatchers;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonarsource.analyzer.commons.regex.RegexParseResult;

public abstract class AbstractRegexCheckTrackingMatchType
extends AbstractRegexCheckTrackingMatchers {
    private static final MethodMatchers PARTIAL_MATCHERS = MethodMatchers.or(MethodMatchers.create().ofTypes("java.util.regex.Pattern", "java.lang.String").names("split", "splitAsStream", "asPredicate", "replaceAll", "replaceFirst").withAnyParameters().build(), MethodMatchers.create().ofTypes("java.util.regex.Matcher").names("find").withAnyParameters().build(), MethodMatchers.create().ofTypes("org.apache.commons.lang3.RegExUtils").names("removeAll", "removeFirst", "removePattern", "replaceAll", "replaceFirst", "replacePattern").withAnyParameters().build());
    private static final MethodMatchers FULL_MATCHERS = MethodMatchers.create().ofTypes("java.util.regex.Pattern", "java.util.regex.Matcher", "java.lang.String").names("matches", "asMatchPredicate").withAnyParameters().build();
    private static final MethodMatchers MATCHERS = MethodMatchers.or(PARTIAL_MATCHERS, FULL_MATCHERS);

    protected abstract void checkRegex(RegexParseResult var1, ExpressionTree var2, MatchType var3);

    @Override
    protected MethodMatchers trackedMethodMatchers() {
        return MATCHERS;
    }

    @Override
    protected void checkRegex(RegexParseResult regexForLiterals, ExpressionTree methodInvocationOrAnnotation, List<MethodInvocationTree> trackedMethodsCalled, boolean didEscape) {
        MatchType matchType;
        if (methodInvocationOrAnnotation.is(Tree.Kind.ANNOTATION)) {
            matchType = MatchType.FULL;
        } else if (didEscape) {
            matchType = MatchType.UNKNOWN;
        } else {
            boolean partial = trackedMethodsCalled.stream().anyMatch(PARTIAL_MATCHERS::matches);
            boolean full = trackedMethodsCalled.stream().anyMatch(FULL_MATCHERS::matches);
            matchType = partial && full ? MatchType.BOTH : (partial ? MatchType.PARTIAL : (full ? MatchType.FULL : MatchType.UNKNOWN));
        }
        this.checkRegex(regexForLiterals, methodInvocationOrAnnotation, matchType);
    }

    protected static enum MatchType {
        FULL,
        PARTIAL,
        BOTH,
        UNKNOWN;

    }
}

