/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.helpers;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;

public class UnresolvedIdentifiersVisitor
extends BaseTreeVisitor {
    private Set<String> unresolvedIdentifierNames = new HashSet<String>();

    @Override
    public void visitMemberSelectExpression(MemberSelectExpressionTree tree) {
        this.scan(tree.expression());
    }

    @Override
    public void visitMethodInvocation(MethodInvocationTree tree) {
        ExpressionTree methodSelect = tree.methodSelect();
        if (!methodSelect.is(Tree.Kind.IDENTIFIER)) {
            this.scan(methodSelect);
        }
        this.scan(tree.typeArguments());
        this.scan(tree.arguments());
    }

    @Override
    public void visitIdentifier(IdentifierTree tree) {
        if (tree.symbol().isUnknown()) {
            this.unresolvedIdentifierNames.add(tree.name());
        }
        super.visitIdentifier(tree);
    }

    public Set<String> check(Tree tree) {
        this.unresolvedIdentifierNames.clear();
        tree.accept(this);
        return this.unresolvedNames();
    }

    public Set<String> check(List<? extends Tree> trees) {
        this.unresolvedIdentifierNames.clear();
        trees.forEach(tree -> tree.accept(this));
        return this.unresolvedNames();
    }

    private Set<String> unresolvedNames() {
        return Collections.unmodifiableSet(this.unresolvedIdentifierNames);
    }

    public boolean isUnresolved(String candidate) {
        return this.unresolvedIdentifierNames.contains(candidate);
    }
}

