/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.sonar.check.Rule;
import org.sonar.java.checks.helpers.ExpressionsHelper;
import org.sonar.java.model.JWarning;
import org.sonar.java.model.JavaTree;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.ImportTree;
import org.sonar.plugins.java.api.tree.PackageDeclarationTree;
import org.sonar.plugins.java.api.tree.SyntaxTrivia;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonarsource.analyzer.commons.annotations.DeprecatedRuleKey;

@DeprecatedRuleKey(ruleKey="UselessImportCheck", repositoryKey="squid")
@Rule(key="S1128")
public class UselessImportCheck
extends IssuableSubscriptionVisitor {
    private static final Pattern COMPILER_WARNING = Pattern.compile("The import ([$\\w]+(\\.[$\\w]+)*+) is never used");
    private static final Pattern NON_WORDS_CHARACTERS = Pattern.compile("\\W+");
    private static final Pattern JAVADOC_REFERENCE = Pattern.compile("\\{@link[^\\}]*\\}|(@see|@throws)[^\n]*\n");
    private String currentPackage = "";
    private final Map<String, String> importsNames = new HashMap<String, String>();
    private final Set<String> duplicatedImports = new HashSet<String>();
    private final Set<String> usedInJavaDoc = new HashSet<String>();

    @Override
    public List<Tree.Kind> nodesToVisit() {
        return Arrays.asList(Tree.Kind.TRIVIA, Tree.Kind.COMPILATION_UNIT, Tree.Kind.PACKAGE, Tree.Kind.IMPORT);
    }

    @Override
    public void visitNode(Tree tree) {
        if (tree.is(Tree.Kind.COMPILATION_UNIT)) {
            this.importsNames.clear();
            this.duplicatedImports.clear();
            this.usedInJavaDoc.clear();
            this.currentPackage = "";
        } else if (tree.is(Tree.Kind.PACKAGE)) {
            this.currentPackage = ExpressionsHelper.concatenate(((PackageDeclarationTree)tree).packageName());
        } else {
            this.handleImportTree((ImportTree)tree);
        }
    }

    @Override
    public void leaveNode(Tree tree) {
        if (tree.is(Tree.Kind.COMPILATION_UNIT)) {
            this.handleWarnings(((JavaTree.CompilationUnitTreeImpl)tree).warnings(JWarning.Type.UNUSED_IMPORT));
        }
    }

    private void handleWarnings(List<JWarning> warnings) {
        for (JWarning warning : warnings) {
            Matcher matcher = COMPILER_WARNING.matcher(warning.message());
            Optional<String> fqn = matcher.find() ? Optional.of(matcher.group(1)) : Optional.empty();
            fqn.ifPresent(importName -> {
                if (!this.usedInJavaDoc.contains(importName) && !importName.startsWith("java.lang")) {
                    String message = this.duplicatedImports.contains(importName) ? "Remove this duplicated import." : (importName.startsWith(this.currentPackage) ? "Remove this unnecessary import: same package classes are always implicitly imported." : "Remove this unused import '" + importName + "'.");
                    this.reportIssue(((ImportTree)warning.syntaxTree()).qualifiedIdentifier(), message);
                }
            });
        }
    }

    private void handleImportTree(ImportTree importTree) {
        String importName = ExpressionsHelper.concatenate((ExpressionTree)importTree.qualifiedIdentifier());
        if (this.importsNames.containsKey(importName)) {
            this.duplicatedImports.add(importName);
        } else {
            this.importsNames.put(importName, UselessImportCheck.extractLastClassName(importName));
        }
        if (UselessImportCheck.isJavaLangImport(importName)) {
            this.reportIssue(importTree.qualifiedIdentifier(), "Remove this unnecessary import: java.lang classes are always implicitly imported.");
        }
    }

    private static String extractLastClassName(String reference) {
        int lastIndexOfDot = reference.lastIndexOf(46);
        return lastIndexOfDot == -1 ? reference : reference.substring(lastIndexOfDot + 1);
    }

    private static boolean isJavaLangImport(String reference) {
        return reference.startsWith("java.lang.") && reference.indexOf(46, "java.lang.".length()) == -1;
    }

    @Override
    public void visitTrivia(SyntaxTrivia syntaxTrivia) {
        String comment = syntaxTrivia.comment();
        if (!comment.startsWith("/**")) {
            return;
        }
        Matcher matcher = JAVADOC_REFERENCE.matcher(comment);
        while (matcher.find()) {
            String line = matcher.group(0);
            Set words = NON_WORDS_CHARACTERS.splitAsStream(line).filter(w -> !w.isEmpty()).collect(Collectors.toSet());
            if (words.isEmpty()) continue;
            this.importsNames.forEach((fullyQualifiedName, name) -> {
                if (words.contains(name)) {
                    this.usedInJavaDoc.add((String)fullyQualifiedName);
                }
            });
        }
    }
}

