/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.sonar.check.Rule;
import org.sonar.java.model.JWarning;
import org.sonar.java.model.JavaTree;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.CatchTree;
import org.sonar.plugins.java.api.tree.ListTree;
import org.sonar.plugins.java.api.tree.SyntaxToken;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TryStatementTree;
import org.sonar.plugins.java.api.tree.TypeTree;
import org.sonar.plugins.java.api.tree.UnionTypeTree;

@Rule(key="S4970")
public class UnreachableCatchCheck
extends IssuableSubscriptionVisitor {
    private final List<JWarning> warnings = new ArrayList<JWarning>();
    private static final Comparator<JavaFileScannerContext.Location> LOCATION_COMAPRATOR = Comparator.comparingInt(loc -> loc.syntaxNode.firstToken().line()).thenComparing(Comparator.comparingInt(loc -> loc.syntaxNode.firstToken().column()));

    @Override
    public List<Tree.Kind> nodesToVisit() {
        return Arrays.asList(Tree.Kind.COMPILATION_UNIT, Tree.Kind.TRY_STATEMENT);
    }

    @Override
    public void visitNode(Tree tree) {
        if (tree.is(Tree.Kind.COMPILATION_UNIT)) {
            this.warnings.clear();
            this.warnings.addAll(((JavaTree.CompilationUnitTreeImpl)tree).warnings(JWarning.Type.MASKED_CATCH));
            return;
        }
        this.checkWarnings((TryStatementTree)tree);
    }

    private void checkWarnings(TryStatementTree tryStatementTree) {
        ArrayList<TypeTree> typesWithWarnings = new ArrayList<TypeTree>(this.warnings.size());
        ArrayList<UnionTypeTree> unionTypes = new ArrayList<UnionTypeTree>();
        HashMap<TypeTree, Type> typeByExceptions = new HashMap<TypeTree, Type>();
        HashMap<TypeTree, Tree> reportTrees = new HashMap<TypeTree, Tree>();
        for (CatchTree catchTree : tryStatementTree.catches()) {
            SyntaxToken catchKeyword = catchTree.catchKeyword();
            TypeTree caughtException = catchTree.parameter().type();
            boolean withinUnionType = caughtException.is(Tree.Kind.UNION_TYPE);
            if (withinUnionType) {
                reportTrees.put(caughtException, catchKeyword);
                unionTypes.add((UnionTypeTree)caughtException);
            }
            for (TypeTree typeTree : UnreachableCatchCheck.caughtExceptionTypes(caughtException)) {
                typeByExceptions.put(typeTree, typeTree.symbolType());
                reportTrees.put(typeTree, withinUnionType ? typeTree : catchKeyword);
                this.warnings.stream().filter(warning -> typeTree.equals(warning.syntaxTree())).forEach(warning -> typesWithWarnings.add(typeTree));
            }
        }
        this.reportUnreacheableCatch(typesWithWarnings, typeByExceptions, reportTrees, unionTypes);
    }

    private static List<TypeTree> caughtExceptionTypes(TypeTree caughtException) {
        if (caughtException.is(Tree.Kind.UNION_TYPE)) {
            return ((UnionTypeTree)caughtException).typeAlternatives();
        }
        return Collections.singletonList(caughtException);
    }

    private void reportUnreacheableCatch(List<TypeTree> typesWithWarnings, Map<TypeTree, Type> typeByExceptions, Map<TypeTree, Tree> reportTrees, List<UnionTypeTree> unionTypes) {
        for (TypeTree type : UnreachableCatchCheck.typesToReport(typesWithWarnings, unionTypes)) {
            this.reportIssue(reportTrees.get(type), UnreachableCatchCheck.message(reportTrees.get(type)), UnreachableCatchCheck.secondaries(type, typeByExceptions), null);
        }
    }

    private static List<TypeTree> typesToReport(List<TypeTree> typesWithWarnings, List<UnionTypeTree> unionTypes) {
        ArrayList<TypeTree> typesToReport = new ArrayList<TypeTree>(typesWithWarnings);
        for (UnionTypeTree unionType : unionTypes) {
            ListTree<TypeTree> typeAlternatives = unionType.typeAlternatives();
            if (!typesWithWarnings.containsAll(typeAlternatives)) continue;
            typesToReport.add(unionType);
            typesToReport.removeAll(typeAlternatives);
        }
        return typesToReport;
    }

    private static String message(Tree reportTree) {
        if (reportTree.is(Tree.Kind.TOKEN)) {
            return "Remove or refactor this catch clause because it is unreachable, hidden by previous catch block(s).";
        }
        return "Remove this type because it is unreachable, hidden by previous catch block(s).";
    }

    private static List<JavaFileScannerContext.Location> secondaries(TypeTree type, Map<TypeTree, Type> typeByExceptions) {
        List<Type> targets = type.is(Tree.Kind.UNION_TYPE) ? ((UnionTypeTree)type).typeAlternatives().stream().map(typeByExceptions::get).collect(Collectors.toList()) : Collections.singletonList(typeByExceptions.get(type));
        return UnreachableCatchCheck.childrenExceptionTypes(targets, typeByExceptions);
    }

    private static List<JavaFileScannerContext.Location> childrenExceptionTypes(List<Type> targets, Map<TypeTree, Type> exceptionTypes) {
        ArrayList<JavaFileScannerContext.Location> secondaries = new ArrayList<JavaFileScannerContext.Location>();
        targets.forEach(target -> {
            for (Map.Entry exceptionType : exceptionTypes.entrySet()) {
                TypeTree tree = (TypeTree)exceptionType.getKey();
                Type type = (Type)exceptionType.getValue();
                if (type.equals(target) || !type.isSubtypeOf((Type)target)) continue;
                secondaries.add(new JavaFileScannerContext.Location("Already catch the exception", tree));
            }
        });
        secondaries.sort(LOCATION_COMAPRATOR);
        return secondaries;
    }
}

