/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Deque;
import java.util.LinkedList;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.utils.WildcardPattern;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.java.ast.visitors.PublicApiChecker;
import org.sonar.java.checks.PatternUtils;
import org.sonar.java.checks.helpers.Javadoc;
import org.sonar.java.model.PackageUtils;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.SymbolMetadata;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.CompilationUnitTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.PrimitiveTypeTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TypeTree;
import org.sonar.plugins.java.api.tree.VariableTree;
import org.sonarsource.analyzer.commons.annotations.DeprecatedRuleKey;

@DeprecatedRuleKey(ruleKey="UndocumentedApi", repositoryKey="squid")
@Rule(key="S1176")
public class UndocumentedApiCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    private static final Tree.Kind[] CLASS_KINDS = PublicApiChecker.classKinds();
    private static final Tree.Kind[] METHOD_KINDS = PublicApiChecker.methodKinds();
    private static final String DEFAULT_FOR_CLASSES = "**.api.**";
    private static final String DEFAULT_EXCLUSION = "**.internal.**";
    @RuleProperty(key="forClasses", description="Pattern of classes which should adhere to this constraint. Ex : **.api.**", defaultValue="**.api.**")
    public String forClasses = "**.api.**";
    @RuleProperty(key="exclusion", description="Pattern of classes which are excluded from adhering to this constraint.", defaultValue="**.internal.**")
    public String exclusion = "**.internal.**";
    private WildcardPattern[] inclusionPatterns;
    private WildcardPattern[] exclusionPatterns;
    private final Deque<ClassTree> classTrees = new LinkedList<ClassTree>();
    private final Deque<Tree> currentParents = new LinkedList<Tree>();
    private String packageName;
    private final Pattern setterPattern = Pattern.compile("set[A-Z].*");
    private final Pattern getterPattern = Pattern.compile("(get|is)[A-Z].*");
    private JavaFileScannerContext context;

    @Override
    public void scanFile(JavaFileScannerContext context) {
        if (context.getSemanticModel() == null) {
            return;
        }
        this.classTrees.clear();
        this.currentParents.clear();
        this.packageName = "";
        this.context = context;
        this.scan(context.getTree());
    }

    @Override
    public void visitCompilationUnit(CompilationUnitTree tree) {
        this.packageName = PackageUtils.packageName(tree.packageDeclaration(), ".");
        super.visitCompilationUnit(tree);
    }

    @Override
    public void visitNewClass(NewClassTree tree) {
    }

    @Override
    public void visitClass(ClassTree tree) {
        this.visitNode(tree, tree.simpleName(), tree.symbol().metadata());
        super.visitClass(tree);
        this.classTrees.pop();
        this.currentParents.pop();
    }

    @Override
    public void visitVariable(VariableTree tree) {
        this.visitNode(tree, tree.simpleName(), tree.symbol().metadata());
        super.visitVariable(tree);
    }

    @Override
    public void visitMethod(MethodTree tree) {
        this.visitNode(tree, tree.simpleName(), tree.symbol().metadata());
        super.visitMethod(tree);
        this.currentParents.pop();
    }

    private void visitNode(Tree tree, Tree reportTree, SymbolMetadata symbolMetadata) {
        if (!this.isExcluded(tree, symbolMetadata)) {
            Javadoc javadoc = new Javadoc(tree);
            if (javadoc.noMainDescription() && !this.isNonVoidMethodWithNoParameter(tree, javadoc)) {
                this.context.reportIssue(this, reportTree, "Document this public " + UndocumentedApiCheck.getType(tree) + " by adding an explicit description.");
            } else {
                Set<String> undocumentedExceptions;
                Set<String> undocumentedParameters = javadoc.undocumentedParameters();
                if (!undocumentedParameters.isEmpty()) {
                    this.context.reportIssue(this, reportTree, "Document the parameter(s): " + undocumentedParameters.stream().collect(Collectors.joining(", ")));
                }
                if (this.hasNonVoidReturnType(tree) && javadoc.noReturnDescription()) {
                    this.context.reportIssue(this, reportTree, "Document this method return value.");
                }
                if (!(undocumentedExceptions = javadoc.undocumentedThrownExceptions()).isEmpty()) {
                    this.context.reportIssue(this, reportTree, "Document this method thrown exception(s): " + undocumentedExceptions.stream().collect(Collectors.joining(", ")));
                }
            }
        }
    }

    private boolean isNonVoidMethodWithNoParameter(Tree tree, Javadoc javadoc) {
        if (!tree.is(Tree.Kind.METHOD)) {
            return false;
        }
        return this.hasNonVoidReturnType(tree) && ((MethodTree)tree).parameters().isEmpty() && !javadoc.noReturnDescription();
    }

    private static String getType(Tree tree) {
        switch (tree.kind()) {
            case CONSTRUCTOR: {
                return "constructor";
            }
            case METHOD: {
                return "method";
            }
            case VARIABLE: {
                return "field";
            }
            case CLASS: {
                return "class";
            }
            case INTERFACE: {
                return "interface";
            }
            case ENUM: {
                return "enum";
            }
            case ANNOTATION_TYPE: {
                return "annotation";
            }
        }
        return "";
    }

    private boolean isExcluded(Tree tree, SymbolMetadata symbolMetadata) {
        return !this.isPublicApi(tree) || this.isAccessor(tree) || !this.isMatchingInclusionPattern() || this.isMatchingExclusionPattern() || UndocumentedApiCheck.isOverridingMethod(tree) || UndocumentedApiCheck.isVisibleForTestingMethod(tree, symbolMetadata) || UndocumentedApiCheck.hasDeprecatedAnnotation(symbolMetadata);
    }

    private boolean isAccessor(Tree tree) {
        if (!this.classTrees.isEmpty() && tree.is(Tree.Kind.METHOD)) {
            MethodTree methodTree = (MethodTree)tree;
            String name = methodTree.simpleName().name();
            return this.setterPattern.matcher(name).matches() && methodTree.parameters().size() == 1 || this.getterPattern.matcher(name).matches() && methodTree.parameters().isEmpty();
        }
        return false;
    }

    private boolean isPublicApi(Tree tree) {
        Tree currentParent = this.currentParents.peek();
        if (tree.is(CLASS_KINDS)) {
            this.classTrees.push((ClassTree)tree);
            this.currentParents.push(tree);
        } else if (tree.is(METHOD_KINDS)) {
            this.currentParents.push(tree);
        }
        return PublicApiChecker.isPublicApi(currentParent, tree);
    }

    private boolean isMatchingInclusionPattern() {
        return WildcardPattern.match((WildcardPattern[])this.getInclusionPatterns(), (String)this.className());
    }

    private boolean isMatchingExclusionPattern() {
        return WildcardPattern.match((WildcardPattern[])this.getExclusionPatterns(), (String)this.className());
    }

    private static boolean isOverridingMethod(Tree tree) {
        return tree.is(Tree.Kind.METHOD) && !Boolean.FALSE.equals(((MethodTree)tree).isOverriding());
    }

    private static boolean isVisibleForTestingMethod(Tree tree, SymbolMetadata symbolMetadata) {
        return tree.is(Tree.Kind.METHOD) && (symbolMetadata.isAnnotatedWith("org.fest.util.VisibleForTesting") || symbolMetadata.isAnnotatedWith("com.google.common.annotations.VisibleForTesting"));
    }

    private static boolean hasDeprecatedAnnotation(SymbolMetadata symbolMetadata) {
        return symbolMetadata.isAnnotatedWith("java.lang.Deprecated");
    }

    private String className() {
        String className = this.packageName;
        IdentifierTree identifierTree = this.classTrees.peek().simpleName();
        if (identifierTree != null) {
            className = className + "." + identifierTree.name();
        }
        return className;
    }

    private WildcardPattern[] getInclusionPatterns() {
        if (this.inclusionPatterns == null) {
            if (StringUtils.isEmpty(this.forClasses)) {
                this.forClasses = "**";
            }
            this.inclusionPatterns = PatternUtils.createPatterns(this.forClasses);
        }
        return this.inclusionPatterns;
    }

    private WildcardPattern[] getExclusionPatterns() {
        if (this.exclusionPatterns == null) {
            this.exclusionPatterns = StringUtils.isEmpty(this.exclusion) ? new WildcardPattern[0] : PatternUtils.createPatterns(this.exclusion);
        }
        return this.exclusionPatterns;
    }

    private boolean hasNonVoidReturnType(Tree tree) {
        if (tree.is(Tree.Kind.METHOD) && !this.classTrees.peek().is(Tree.Kind.ANNOTATION_TYPE)) {
            TypeTree returnType = ((MethodTree)tree).returnType();
            return returnType == null || !returnType.is(Tree.Kind.PRIMITIVE_TYPE) || !"void".equals(((PrimitiveTypeTree)returnType).keyword().text());
        }
        return false;
    }
}

