/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import org.sonar.check.Rule;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;

@Rule(key="S2236")
public class ThreadWaitCallCheck
extends AbstractMethodDetection {
    @Override
    protected void onMethodInvocationFound(MethodInvocationTree mit) {
        this.reportIssue(ExpressionUtils.methodName(mit), "Refactor the synchronisation mechanism to not use a Thread instance as a monitor");
    }

    @Override
    protected MethodMatchers getMethodInvocationMatchers() {
        return MethodMatchers.or(MethodMatchers.create().ofSubTypes("java.lang.Thread").names("wait").addParametersMatcher("long").addParametersMatcher("long", "int").build(), MethodMatchers.create().ofSubTypes("java.lang.Thread").names("wait", "notify", "notifyAll").addWithoutParametersMatcher().build());
    }
}

