/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Collections;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.Arguments;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TypeTree;

@Rule(key="S2134")
public class ThreadOverridesRunCheck
extends IssuableSubscriptionVisitor {
    private static final String JAVA_LANG_THREAD = "java.lang.Thread";
    private static final MethodMatchers RUN = MethodMatchers.create().ofSubTypes("java.lang.Thread").names("run").addWithoutParametersMatcher().build();

    @Override
    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.CLASS);
    }

    @Override
    public void visitNode(Tree tree) {
        ClassTree classTree = (ClassTree)tree;
        Symbol.TypeSymbol classSymbol = classTree.symbol();
        if (classSymbol != null && ThreadOverridesRunCheck.isDirectSubtypeOfThread(classSymbol) && !ThreadOverridesRunCheck.overridesRunMethod(classSymbol) && !ThreadOverridesRunCheck.hasConstructorCallingSuperWithRunnable(classTree)) {
            TypeTree report = classTree.simpleName();
            Tree parent = classTree.parent();
            if (parent.is(Tree.Kind.NEW_CLASS)) {
                NewClassTree newClassTree = (NewClassTree)parent;
                if (ThreadOverridesRunCheck.hasRunnableArgument(newClassTree.arguments())) {
                    return;
                }
                report = newClassTree.identifier();
            }
            this.reportIssue(report, "Don't extend \"Thread\", since the \"run\" method is not overridden.");
        }
    }

    private static boolean isDirectSubtypeOfThread(Symbol.TypeSymbol classSymbol) {
        Type superClass = classSymbol.superClass();
        return superClass != null && superClass.is(JAVA_LANG_THREAD);
    }

    private static boolean overridesRunMethod(Symbol.TypeSymbol classSymbol) {
        return classSymbol.lookupSymbols("run").stream().anyMatch(RUN::matches);
    }

    private static boolean hasConstructorCallingSuperWithRunnable(ClassTree classTree) {
        return classTree.members().stream().filter(member -> member.is(Tree.Kind.CONSTRUCTOR)).map(MethodTree.class::cast).anyMatch(ThreadOverridesRunCheck::hasCallToSuperWithRunnable);
    }

    private static boolean hasRunnableArgument(Arguments args) {
        return args.stream().anyMatch(ThreadOverridesRunCheck::isRunnable);
    }

    private static boolean isRunnable(ExpressionTree arg) {
        return arg.symbolType().isSubtypeOf("java.lang.Runnable");
    }

    private static boolean hasCallToSuperWithRunnable(MethodTree constructor) {
        SuperRunnableVisitor visitor = new SuperRunnableVisitor();
        constructor.accept(visitor);
        return visitor.callSuperWithRunnable;
    }

    private static class SuperRunnableVisitor
    extends BaseTreeVisitor {
        private boolean callSuperWithRunnable = false;
        private static final MethodMatchers SUPER_THREAD = MethodMatchers.create().ofTypes("java.lang.Thread").constructor().withAnyParameters().build();

        private SuperRunnableVisitor() {
        }

        @Override
        public void visitMethodInvocation(MethodInvocationTree tree) {
            if (SUPER_THREAD.matches(tree) && ThreadOverridesRunCheck.hasRunnableArgument(tree.arguments())) {
                this.callSuperWithRunnable = true;
                return;
            }
            super.visitMethodInvocation(tree);
        }

        @Override
        public void visitClass(ClassTree tree) {
        }
    }
}

