/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.tree.BlockTree;
import org.sonar.plugins.java.api.tree.CaseGroupTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.LabeledStatementTree;
import org.sonar.plugins.java.api.tree.StatementTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S1219")
public class SwitchWithLabelsCheck
extends IssuableSubscriptionVisitor {
    @Override
    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.CASE_GROUP);
    }

    @Override
    public void visitNode(Tree tree) {
        CaseGroupTree cgt = (CaseGroupTree)tree;
        cgt.body().stream().flatMap(SwitchWithLabelsCheck::getStatementTreeStream).map(LabeledStatementTree.class::cast).forEach(this::reportLabeledStatement);
    }

    private static Stream<StatementTree> getStatementTreeStream(StatementTree statementTree) {
        if (statementTree.is(Tree.Kind.LABELED_STATEMENT)) {
            return Stream.of(statementTree);
        }
        if (statementTree.is(Tree.Kind.BLOCK)) {
            return ((BlockTree)statementTree).body().stream().filter(st -> st.is(Tree.Kind.LABELED_STATEMENT));
        }
        return Stream.empty();
    }

    private void reportLabeledStatement(LabeledStatementTree statementTree) {
        IdentifierTree label = statementTree.label();
        this.reportIssue(label, "Remove this misleading \"" + label.name() + "\" label.");
    }
}

