/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Deque;
import java.util.LinkedList;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.java.model.SyntacticEquivalence;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.ArrayAccessExpressionTree;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.BinaryExpressionTree;
import org.sonar.plugins.java.api.tree.DoWhileStatementTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.ForEachStatement;
import org.sonar.plugins.java.api.tree.ForStatementTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.WhileStatementTree;

@Rule(key="S1643")
public class StringConcatenationInLoopCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    private JavaFileScannerContext context;
    private Deque<Tree> loopLevel = new LinkedList<Tree>();

    @Override
    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        this.loopLevel.clear();
        this.scan(context.getTree());
    }

    @Override
    public void visitAssignmentExpression(AssignmentExpressionTree tree) {
        if (!this.loopLevel.isEmpty() && StringConcatenationInLoopCheck.isStringConcatenation(tree) && this.isNotLoopLocalVar(tree) && StringConcatenationInLoopCheck.isNotArrayAccess(tree)) {
            this.context.reportIssue(this, tree.variable(), "Use a StringBuilder instead.");
        }
        super.visitAssignmentExpression(tree);
    }

    private boolean isNotLoopLocalVar(AssignmentExpressionTree tree) {
        Tree parent;
        IdentifierTree idTree = StringConcatenationInLoopCheck.getIdentifierTree(tree.variable());
        if (idTree == null) {
            return false;
        }
        Tree declaration = idTree.symbol().declaration();
        if (declaration == null) {
            return true;
        }
        Tree parentLoop = this.loopLevel.peek();
        for (parent = declaration.parent(); parent != null && !parent.equals(parentLoop); parent = parent.parent()) {
            if (!parent.is(Tree.Kind.CLASS, Tree.Kind.ENUM, Tree.Kind.INTERFACE, Tree.Kind.METHOD, Tree.Kind.LAMBDA_EXPRESSION)) continue;
            return true;
        }
        return parent == null;
    }

    private static boolean isNotArrayAccess(AssignmentExpressionTree tree) {
        return !tree.variable().is(Tree.Kind.ARRAY_ACCESS_EXPRESSION);
    }

    @Nullable
    private static IdentifierTree getIdentifierTree(ExpressionTree tree) {
        tree = ExpressionUtils.skipParentheses(tree);
        switch (tree.kind()) {
            case IDENTIFIER: {
                return (IdentifierTree)tree;
            }
            case MEMBER_SELECT: {
                return StringConcatenationInLoopCheck.getIdentifierTree(((MemberSelectExpressionTree)tree).expression());
            }
            case ARRAY_ACCESS_EXPRESSION: {
                return StringConcatenationInLoopCheck.getIdentifierTree(((ArrayAccessExpressionTree)tree).expression());
            }
            case METHOD_INVOCATION: {
                return StringConcatenationInLoopCheck.getIdentifierTree(((MethodInvocationTree)tree).methodSelect());
            }
        }
        return null;
    }

    private static boolean isStringConcatenation(AssignmentExpressionTree tree) {
        return tree.symbolType().is("java.lang.String") && StringConcatenationInLoopCheck.isConcatenation(tree);
    }

    private static boolean isConcatenation(AssignmentExpressionTree tree) {
        if (tree.is(Tree.Kind.ASSIGNMENT)) {
            ExpressionTree expressionTree = ExpressionUtils.skipParentheses(tree.expression());
            return expressionTree.is(Tree.Kind.PLUS) && StringConcatenationInLoopCheck.concatenateVariable(tree.variable(), (BinaryExpressionTree)expressionTree);
        }
        return tree.is(Tree.Kind.PLUS_ASSIGNMENT);
    }

    private static boolean concatenateVariable(ExpressionTree variable, BinaryExpressionTree plus) {
        return StringConcatenationInLoopCheck.concatenateVariable(variable, plus.leftOperand()) || StringConcatenationInLoopCheck.concatenateVariable(variable, plus.rightOperand());
    }

    private static boolean concatenateVariable(ExpressionTree variable, ExpressionTree operand) {
        if (operand.is(Tree.Kind.PLUS)) {
            return StringConcatenationInLoopCheck.concatenateVariable(variable, (BinaryExpressionTree)operand);
        }
        return SyntacticEquivalence.areEquivalent(variable, operand);
    }

    @Override
    public void visitForEachStatement(ForEachStatement tree) {
        this.loopLevel.push(tree);
        super.visitForEachStatement(tree);
        this.loopLevel.pop();
    }

    @Override
    public void visitForStatement(ForStatementTree tree) {
        this.loopLevel.push(tree);
        super.visitForStatement(tree);
        this.loopLevel.pop();
    }

    @Override
    public void visitWhileStatement(WhileStatementTree tree) {
        this.loopLevel.push(tree);
        super.visitWhileStatement(tree);
        this.loopLevel.pop();
    }

    @Override
    public void visitDoWhileStatement(DoWhileStatementTree tree) {
        this.loopLevel.push(tree);
        super.visitDoWhileStatement(tree);
        this.loopLevel.pop();
    }
}

